% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.corpus_function.R
\name{install.corpus}
\alias{install.corpus}
\alias{remove.corpus}
\alias{rename.corpus}
\alias{copy.corpus}
\alias{packaged.corpora}
\alias{copy.corpus}
\alias{rename.corpus}
\alias{remove.corpus}
\title{Install packaged corpus from repository.}
\usage{
install.corpus(pkgs, repo = "http://polmine.sowi.uni-due.de/packages",
  lib = .libPaths()[1], ...)

packaged.corpora()

copy.corpus(old, new, verbose = TRUE)

rename.corpus(old, new, verbose = TRUE)

remove.corpus(old)
}
\arguments{
\item{pkgs}{names of data packages with corpora}

\item{repo}{URL of the repository}

\item{lib}{directory for R packages, defaults to \code{.libPaths()[1]}; the path may not 
include a whitespace sign}

\item{...}{further parameters that will be passed into \code{install.packages}}

\item{old}{name of the (old) corpus}

\item{new}{name of the (new) corpus}

\item{verbose}{logical, whether to be verbose}
}
\description{
Convenience function for making the installation of indexed CWB corpora
wrapped into R data packages as easy as possible. Packaged corpora can
then be used by calling \code{\link{use}}.
}
\details{
The function combines two steps necessary to install a CWB corpus wrapped into
a R data package. First, it calls \code{install.packages}, then it 
resets the path pointing to the directory with the indexed corpus
files in the registry file.

The corpus will be installed to the standard library directory for installing R packages
(\code{.libPaths{}[1]}). Another location can be used by stating the param 'lib'
explicitly (see documentation for \code{\link{install.packages}}).

The function can also be used to install a corpus from a password protected repository. Further
parameters are handed over to install.packages, so you might add 
\code{method = "wget" extra = "--user donald --password duck"}.

See examples how to check whether the directory has been set correctly.

An installed data package with a CWB corpus is assumed to include a directory
\code{/extdata/cwb/registry} for registry files and a directory
\code{/extdata/cwb/indexed_corpora} for the inexed corpus files.
}
\examples{
\donttest{
install.corpus("plprbt.pvs2017")
# is equivalent to:
install.corpus("plprbt.pvs2017", repo = "http://polmine.sowi.uni-due.de/packages")
RegistryFile(package = "plprbt.pvs2017")$adjustHome()
# check the directory that has been set
RegistryFile$new(package = "plprbt.pvs2017")$getHome()
}
}
\seealso{
For managing registry files, see class \code{\link{RegistryFile}}, see \code{\link{use}}
for switching to a packaged corpus.
}
