% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matches_method.R
\docType{methods}
\name{matches}
\alias{matches}
\alias{matches}
\alias{matches,partition-method}
\alias{matches,character-method}
\title{Matches for queries.}
\usage{
matches(.Object, ...)

\S4method{matches}{partition}(.Object, query, cqp = is.cqp,
  pAttribute = getOption("polmineR.pAttribute"))

\S4method{matches}{character}(.Object, query, cqp = is.cqp,
  pAttribute = getOption("polmineR.pAttribute"))
}
\arguments{
\item{.Object}{a partition object}

\item{...}{further parameters}

\item{query}{a query, CQP syntax may be used}

\item{cqp}{either logical to indicate whether the query uses CQP syntax, or a function to determine
whether query is a CQP query (defaults to helper function \code{is.cqp})}

\item{pAttribute}{pAttribute}
}
\value{
a data.table
}
\description{
If one query is supplied, the function returns a frequency breakdown of the results of the query.
If several queries are supplied, frequencies for the individual queries are retrieved.
}
\examples{
\dontrun{
use("polmineR.sampleCorpus")
matches("PLPRBTTXT", '"Integration.*"')

P <- partition("PLPRBTTXT", text_date = "2009-11-11")
matches(P, '"Integration.*"')
}
}
\seealso{
\code{\link{hits-class}}
}
