% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/chart.R
\name{pollstr_chart}
\alias{pollstr_chart}
\title{Return a single chart}
\usage{
pollstr_chart(slug, convert = TRUE)
}
\arguments{
\item{slug}{The slug-name of the chart to be returned.}

\item{convert}{Rearrange the data returned by the API into easier to use data frames.}
}
\value{
If \code{convert=TRUE}, then a \code{"pollstr_chart"} object with elements
\itemize{
\item \code{title} Title of the chart.
\item \code{slug} Slug (URL-friendly title) of the chart.
\item \code{topic} Topic of the chart.
\item \code{short_title} Short title of the chart.
\item \code{poll_count} Number of polls in the chart.
\item \code{last_updated} Time the chart was last updated.
\item \code{url} URL of the chart.
\item \code{estimates} A data frame with an observation for each choice and the current estimates.
\item \code{estimates_by_date} A data frame with an observation for each choice at each date, with estimates.
}
Otherwise, a \code{"list"} in the original structure of the json returned by the API.
}
\description{
Return a single chart. This includes both current and historical estimates by date.
}
\examples{
\dontrun{
chart1 <- pollstr_chart('2012-general-election-romney-vs-obama')
}
}
\references{
\url{http://elections.huffingtonpost.com/pollster/api}
}

