% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nuisance_functions.R
\name{predict.nuisance_functions}
\alias{predict.nuisance_functions}
\title{Predict g-functions and Q-functions}
\usage{
\method{predict}{nuisance_functions}(object, new_policy_data, ...)
}
\arguments{
\item{object}{Object of class "nuisance_functions". Either \code{g_functions}
or \code{q_functions} as returned by \code{\link[=policy_eval]{policy_eval()}} or \code{\link[=policy_learn]{policy_learn()}}.}

\item{new_policy_data}{Policy data object created by \code{\link[=policy_data]{policy_data()}}.}

\item{...}{Additional arguments.}
}
\value{
\link[data.table:data.table]{data.table::data.table} with keys \code{id} and \code{stage} and variables \code{g_a} or \code{Q_a} for
each action a in the actions set.
}
\description{
\code{predict()} returns the fitted values of the g-functions and
Q-functions when applied to a (new) policy data object.
}
\examples{
library("polle")
### Single stage:
d <- sim_single_stage(5e2, seed=1)
pd <- policy_data(d, action="A", covariates=list("Z", "B", "L"), utility="U")
pd
# defining a static policy (A=1):
pl <- policy_def(1, name = "A=1")

# doubly robust evaluation of the policy:
pe <- policy_eval(policy_data = pd,
                  policy = pl,
                  g_models = g_glm(),
                  q_models = q_glm())
# summarizing the estimated value of the policy:
pe

# getting the fitted g-function values:
head(predict(get_g_functions(pe), pd))

# getting the fitted Q-function values:
head(predict(get_q_functions(pe), pd))
}
