% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__expr.R
\name{Expr_over}
\alias{Expr_over}
\title{over}
\usage{
Expr_over(...)
}
\arguments{
\item{...}{of strings or columns to group by}
}
\value{
Expr
}
\description{
Apply window function over a subgroup.
This is similar to a groupby + aggregation + self join.
Or similar to \verb{window functions in Postgres <https://www.postgresql.org/docs/current/tutorial-window.html>}_.
}
\examples{
pl$DataFrame(
  val = 1:5,
  a = c("+", "+", "-", "-", "+"),
  b = c("+", "-", "+", "-", "+")
)$select(
  pl$col("val")$count()$over("a", "b")
)

over_vars = c("a", "b")
pl$DataFrame(
  val = 1:5,
  a = c("+", "+", "-", "-", "+"),
  b = c("+", "-", "+", "-", "+")
)$select(
  pl$col("val")$count()$over(over_vars)
)
}
\keyword{Expr}
