% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__datetime.R
\name{ExprDT_ordinal_day}
\alias{ExprDT_ordinal_day}
\alias{(Expr)$dt$ordinal_day}
\title{Ordinal Day}
\format{
function
}
\value{
Expr of ordinal_day as UInt32
}
\description{
Extract ordinal day from underlying Date representation.
Applies to Date and Datetime columns.
Returns the day of year starting from 1.
The return value ranges from 1 to 366. (The last day of year differs by years.)
}
\examples{
df = pl$DataFrame(
  date = pl$date_range(
    as.Date("2020-12-25"),
    as.Date("2021-1-05"),
    interval = "1d",
    time_zone = "GMT",
    lazy = FALSE
  )
)
df$with_columns(
  pl$col("date")$dt$ordinal_day()$alias("ordinal_day")
)
}
\keyword{ExprDT}
