% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__datetime.R
\name{ExprDT_convert_time_zone}
\alias{ExprDT_convert_time_zone}
\alias{(Expr)$dt$convert_time_zone}
\title{With Time Zone}
\format{
function
}
\arguments{
\item{tz}{String time zone from base::OlsonNames()}
}
\value{
Expr of i64
}
\description{
Set time zone for a Series of type Datetime.
Use to change time zone annotation, but keep the corresponding global timepoint.
}
\details{
corresponds to in R manually modifying the tzone attribute of POSIXt objects
}
\examples{
df = pl$DataFrame(
  date = pl$date_range(
    low = as.Date("2001-3-1"),
    high = as.Date("2001-5-1"),
    interval = "1mo",
    lazy = FALSE
  )
)
df$select(
  pl$col("date"),
  pl$col("date")
  $dt$replace_time_zone("Europe/Amsterdam")
  $dt$convert_time_zone("Europe/London")
  $alias("London_with"),
  pl$col("date")
  $dt$tz_localize("Europe/London")
  $alias("London_localize")
)
}
\keyword{ExprDT}
