% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_deactivate.R
\name{remove_steps}
\alias{remove_steps}
\title{Remove one or more of an \emph{agent}'s validation steps}
\usage{
remove_steps(agent, i = NULL)
}
\arguments{
\item{agent}{An agent object of class \code{ptblank_agent}.}

\item{i}{The validation step number, which is assigned to each validation
step in the order of definition. If \code{NULL} (the default) then step removal
won't occur by index.}
}
\value{
A \code{ptblank_agent} object.
}
\description{
Validation steps can be removed from an \emph{agent} object through use of the
\code{remove_steps()} function. This is useful, for instance, when getting an
agent from disk (via the \code{\link[=x_read_disk]{x_read_disk()}} function) and omitting one or more
steps from the \emph{agent}'s validation plan. Please note that when removing
validation steps all stored data extracts will be removed from the \emph{agent}.
}
\section{Function ID}{

9-8
}

\examples{
# Create an agent that has the
# `small_table` object as the
# target table, add a few
# validation steps, and then use
# `interrogate()`
agent_1 <- 
  create_agent(
    read_fn = ~ small_table,
    tbl_name = "small_table",
    label = "An example."
  ) \%>\%
  col_exists(vars(date)) \%>\%
  col_vals_regex(
    vars(b), regex = "[0-9]-[a-z]{3}-[0-9]"
  ) \%>\%
  interrogate()
  
# The second validation step has
# been determined to be unneeded and
# is to be removed; this can be done
# by used `remove_steps()` with the
# agent object
agent_2 <-
  agent_1 \%>\%
  remove_steps(i = 2) \%>\%
  interrogate()

}
\seealso{
Instead of removal, the \code{\link[=deactivate_steps]{deactivate_steps()}} function will simply
change the \code{active} status of one or more validation steps to \code{FALSE} (and
\code{\link[=activate_steps]{activate_steps()}} will do the opposite).

Other Object Ops: 
\code{\link{activate_steps}()},
\code{\link{deactivate_steps}()},
\code{\link{remove_read_fn}()},
\code{\link{remove_tbl}()},
\code{\link{set_read_fn}()},
\code{\link{set_tbl}()},
\code{\link{x_read_disk}()},
\code{\link{x_write_disk}()}
}
\concept{Object Ops}
