% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emailing.R
\name{email_preview}
\alias{email_preview}
\title{Get a preview of an email before actually sending that email}
\usage{
email_preview(
  x,
  msg_header = NULL,
  msg_body = stock_msg_body(),
  msg_footer = stock_msg_footer()
)
}
\arguments{
\item{x}{A pointblank agent or an agent x-list. The x-list object can be
created with the \code{\link[=get_agent_x_list]{get_agent_x_list()}} function. It is recommended that the
\code{i = NULL} and \code{generate_report = TRUE} so that the agent report is
available within the email preview.}

\item{msg_header, msg_body, msg_footer}{Content for the header, body, and
footer components of the HTML email message.}
}
\value{
A \strong{blastula} \code{email_message} object.
}
\description{
The \code{email_preview()} function provides a preview of an email that would
normally be produced and sent through the \code{\link[=email_blast]{email_blast()}} function. The \code{x}
that we need for this is the agent x-list that is produced by the
\code{\link[=get_agent_x_list]{get_agent_x_list()}} function. Or, we can supply an agent object. In both
cases, the email message with appear in the Viewer and a \strong{blastula}
\code{email_message} object will be returned.
}
\section{Function ID}{

3-2
}

\examples{
# Create a simple table with two
# columns of numerical values
tbl <-
  dplyr::tibble(
    a = c(5, 7, 6, 5, 8, 7),
    b = c(7, 1, 0, 0, 0, 3)
  )

# Create an `action_levels()` list
# with absolute values for the
# `warn`, and `notify` states (with
# thresholds of 1 and 2 'fail' units)
al <- 
  action_levels(
    warn_at = 1,
    notify_at = 2
  )

# In a workflow that involves an
# `agent` object, we can set up a
# series of `end_fns` and have report
# emailing with `email_blast()` but,
# first, we can look at the email
# message object beforehand by using
# the `email_preview()` function
# on an `agent` object
email_object <-
  create_agent(
    tbl = tbl,
    actions = al
  ) \%>\%
  col_vals_gt(vars(a), 5) \%>\%
  col_vals_lt(vars(b), 5) \%>\%
  interrogate() \%>\%
  email_preview()

# The `email_preview()` function can
# also be used on an agent x-list to
# get the same email message object
email_object <-
  create_agent(
    tbl = tbl,
    actions = al
  ) \%>\%
  col_vals_gt(vars(a), 5) \%>\%
  col_vals_lt(vars(b), 5) \%>\%
  interrogate() \%>\%
  get_agent_x_list() \%>\%
  email_preview()

# We can view the HTML email just
# by printing `email_object`; it
# should appear in the Viewer

}
\seealso{
Other Emailing: 
\code{\link{email_blast}()},
\code{\link{stock_msg_body}()},
\code{\link{stock_msg_footer}()}
}
\concept{Emailing}
