% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{specifications}
\alias{specifications}
\title{A table containing data pertaining to various specifications}
\format{
A tibble with 8 rows and 12 variables:
\describe{
\item{isbn_numbers}{ISBN-13 numbers; can be validated with the \code{"isbn"}
specification.}
\item{vin_numbers}{VIN numbers (identifiers for motor vehicles); can be
validated with the \code{"vin"} specification.}
\item{zip_codes}{Postal codes for the U.S.; can be validated with the
\code{"postal[USA]"} specification or its \code{"zip"} alias.}
\item{credit_card_numbers}{Credit card numbers; can be validated with the
\code{"credit_card"} specification or the \code{"cc"} alias.}
\item{iban_austria}{IBAN numbers for Austrian accounts; can be validated with
the \code{"iban[AUT]"} specification.}
\item{swift_numbers}{Swift-BIC numbers; can be validated with the \code{"swift"}
specification.}
\item{phone_numbers}{Phone numbers; can be validated with the \code{"phone"}
specification.}
\item{email_addresses}{Email addresses; can be validated with the \code{"email"}
specification.}
\item{urls}{URLs; can be validated with the  \code{"url"} specification.}
\item{ipv4_addresses}{IPv4 addresses; can be validated with the \code{"ipv4"}
specification}
\item{ipv6_addresses}{IPv6 addresses; can be validated with the \code{"ipv6"}
specification}
\item{mac_addresses}{MAC addresses; can be validated with the \code{"mac"}
specification}
}
}
\usage{
specifications
}
\description{
The \code{specifications} dataset is useful for testing the
\code{\link[=col_vals_within_spec]{col_vals_within_spec()}}, \code{\link[=test_col_vals_within_spec]{test_col_vals_within_spec()}}, and
\code{\link[=expect_col_vals_within_spec]{expect_col_vals_within_spec()}} functions. For each column, holding character
values for different specifications, rows 1-5 contain valid values, the 6th
row is an NA value, and the final two values (rows 7 and 8) are invalid.
Different specification (\code{spec}) keywords apply to each of columns when
validating with any of the aforementioned functions.
}
\section{Function ID}{

14-3
}

\examples{
# Here is a glimpse at the data
# available in `specifications`
dplyr::glimpse(specifications)

}
\seealso{
Other Datasets: 
\code{\link{game_revenue}},
\code{\link{game_revenue_info}},
\code{\link{small_table}},
\code{\link{small_table_sqlite}()}
}
\concept{Datasets}
\keyword{datasets}
