% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest.R
\name{nearest_datasets}
\alias{nearest_datasets}
\alias{nearest_datasets.default}
\alias{nearest_datasets.character}
\alias{nearest_datasets.data.frame}
\title{Select nearest datasets given input `x`.}
\usage{
nearest_datasets(x, ...)

\method{nearest_datasets}{default}(x, ...)

\method{nearest_datasets}{character}(
  x,
  n_neighbors = 5,
  dimensions = c("n_instances", "n_features"),
  target_name = "target",
  ...
)

\method{nearest_datasets}{data.frame}(
  x,
  y = NULL,
  n_neighbors = 5,
  dimensions = c("n_instances", "n_features"),
  task = c("classification", "regression"),
  target_name = "target",
  ...
)
}
\arguments{
\item{x}{Character string of dataset name from PMLB,
or data.frame of n_samples x n_features(or n_features+1 with a target column)}

\item{\dots}{Further arguments passed to each method.}

\item{n_neighbors}{Integer. The number of dataset names to return as neighbors.}

\item{dimensions}{Character vector specifying dataset characteristics to include in similarity calculation.
Dimensions must correspond to numeric columns of
[all_summary_stats.tsv](https://github.com/EpistasisLab/pmlb/blob/master/pmlb/all_summary_stats.tsv).
If 'all' (default), uses all numeric columns.}

\item{target_name}{Character string specifying column of target/dependent variable.}

\item{y}{Vector of target column. Required when `x`` does not contain the target column.}

\item{task}{Character string specifying classification or regression for summary stat generation.}
}
\value{
Character string of names of most similar datasets to df, most similar dataset first.
}
\description{
If `x` is a data.frame object, computes dataset characteristics.
If `x` is a character object specifying dataset name from PMLB,
use the already computed dataset statistics/characteristics in `summary_stats`.
}
\examples{
nearest_datasets('penguins')
nearest_datasets(fetch_data('penguins'))

}
