% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plumber-step.R
\name{PlumberStep}
\alias{PlumberStep}
\title{plumber step R6 class}
\description{
an object representing a step in the lifecycle of the treatment
of a request by a plumber router.
}
\section{Super class}{
\code{\link[plumber:Hookable]{plumber::Hookable}} -> \code{PlumberStep}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{srcref}}{from step block}

\item{\code{lines}}{lines from step block}

\item{\code{serializer}}{step serializer function}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PlumberStep-new}{\code{PlumberStep$new()}}
\item \href{#method-PlumberStep-exec}{\code{PlumberStep$exec()}}
\item \href{#method-PlumberStep-registerHook}{\code{PlumberStep$registerHook()}}
\item \href{#method-PlumberStep-clone}{\code{PlumberStep$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Hookable" data-id="registerHooks"><a href='../../plumber/html/Hookable.html#method-Hookable-registerHooks'><code>plumber::Hookable$registerHooks()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlumberStep-new"></a>}}
\if{latex}{\out{\hypertarget{method-PlumberStep-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{\link[=PlumberStep]{PlumberStep()}} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberStep$new(expr, envir, lines, serializer, srcref)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expr}}{step expr}

\item{\code{envir}}{step environment}

\item{\code{lines}}{step block}

\item{\code{serializer}}{step serializer}

\item{\code{srcref}}{\code{srcref} attribute from block}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{PlumberStep} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlumberStep-exec"></a>}}
\if{latex}{\out{\hypertarget{method-PlumberStep-exec}{}}}
\subsection{Method \code{exec()}}{
step execution function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberStep$exec(req, res)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req, res}}{Request and response objects created by a Plumber request}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlumberStep-registerHook"></a>}}
\if{latex}{\out{\hypertarget{method-PlumberStep-registerHook}{}}}
\subsection{Method \code{registerHook()}}{
step hook registration method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberStep$registerHook(
  stage = c("preexec", "postexec", "aroundexec"),
  handler
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{stage}}{a character string.}

\item{\code{handler}}{a step handler function.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlumberStep-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PlumberStep-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberStep$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
