% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WVC.R
\name{WVC_pls}
\alias{WVC_pls}
\title{Weighted Variable Contribution in PLS (WVC-PLS)}
\usage{
WVC_pls(y, X, ncomp, normalize = FALSE, threshold = NULL)
}
\arguments{
\item{y}{Vector of responses.}

\item{X}{Matrix of predictors.}

\item{ncomp}{Number of components.}

\item{normalize}{Divide WVC vectors by maximum value.}

\item{threshold}{Set loading weights smaller than threshold to 0 and recompute component.}
}
\value{
loading weights, loadings, regression coefficients, scores and Y-loadings
plus the WVC weights.
}
\description{
Weighted Variable Contribution in PLS (WVC-PLS)
}
\examples{
library(pls)
data(mayonnaise, package = "pls")
wvc <- WVC_pls(factor(mayonnaise$oil.type), mayonnaise$NIR, 10)
wvcNT <- WVC_pls(factor(mayonnaise$oil.type), mayonnaise$NIR, 10, TRUE, 0.5)
old.par <- par(mfrow=c(3,1), mar=c(2,4,1,1))
matplot(t(mayonnaise$NIR), type='l', col=1, ylab='intensity')
matplot(wvc$W[,1:3], type='l', ylab='W')
matplot(wvcNT$W[,1:3], type='l', ylab='W, thr.=0.5')
par(old.par)

}
