\name{PLS_v1_wvc}
\alias{PLS_v1_wvc}
\title{Light version of PLS\_v1 for cross validation purposes}
\description{
Light version of \code{PLS_v1} for cross validation purposes either on complete or incomplete datasets.
}
\usage{
PLS_v1_wvc(dataY, dataX, nt = 2, dataPredictY = dataX, modele = "pls", scaleX = TRUE, scaleY = NULL, keepcoeffs = FALSE, keepstd.coeffs=FALSE, tol_Xi = 10^(-12))
}
\arguments{
  \item{dataY}{response (training) dataset}
  \item{dataX}{predictor(s) (training) dataset}
  \item{nt}{number of components to be extracted}
  \item{dataPredictY}{predictor(s) (testing) dataset}
  \item{modele}{name of the PLS model to be fitted, only (\code{"pls"} available for this fonction.}
  \item{scaleX}{scale the predictor(s) : must be set to TRUE for \code{modele="pls"} and should be for glms pls.}
  \item{scaleY}{scale the response : Yes/No. Ignored since non always possible for glm responses.}
  \item{keepcoeffs}{whether the coefficients of unstandardized eXplanatory variables should be returned or not.}
  \item{keepstd.coeffs}{whether the coefficients of standardized eXplanatory variables should be returned or not.}
  \item{tol_Xi}{minimal value for Norm2(Xi) and \eqn{\mathrm{det}(pp' \times pp)}{det(pp'*pp)} if there is any missing value in the \code{dataX}. It defaults to \eqn{10^{-12}}{10^{-12}}}
}
\details{
This function is called by \code{\link{PLS_v1_kfoldcv}} in order to perform cross validation either on complete or incomplete datasets.
}
\value{
  \item{valsPredict}{\code{nrow(dataPredictY) * nt} matrix of the predicted values}
  \item{\code{coeffs}}{  If the coefficients of the eXplanatory variables were requested:\cr
        i.e. \code{keepcoeffs=TRUE}.\cr
        \code{ncol(dataX) * 1} matrix of the coefficients of the the eXplanatory variables}
}
\references{
Nicolas Meyer, Myriam Maumy-Bertrand et \enc{Frdric}{Fr\'ed\'eric} Bertrand (2010). Comparaison de la \enc{rgression}{r\'egression} PLS et de la \enc{rgression}{r\'egression} logistique PLS : application aux \enc{donnes}{donn\'ees} \enc{d'alllotypage}{d'all\'elotypage}. \emph{Journal de la Socit Franaise de Statistique}, 151(2), pages 1-18.
\url{http://smf4.emath.fr/Publications/JSFdS/151_2/pdf/sfds_jsfds_151_2_1-18.pdf}
}
\author{\enc{Frdric}{Fr\'ed\'eric} Bertrand\cr
\email{frederic.bertrand@math.unistra.fr}\cr
\url{http://www-irma.u-strasbg.fr/~fbertran/}
}
\note{
Use \code{\link{PLS_lm_wvc}} instead.
}
\seealso{\code{\link{PLS_v1}} for more detailed results, \code{\link{PLS_v1_kfoldcv}} for cross validating models and \code{\link{PLS_v2_wvc}} for the same function dedicated to plsRglm models}
\examples{
data(Cornell)
XCornell<-Cornell[,1:7]
yCornell<-Cornell[,8]
PLS_v1_wvc(dataY=yCornell,dataX=XCornell,nt=3,dataPredictY=XCornell[1,])
PLS_v1_wvc(dataY=yCornell[-c(1,2)],dataX=XCornell[-c(1,2),],nt=3,dataPredictY=XCornell[c(1,2),])
PLS_v1_wvc(dataY=yCornell[-c(1,2)],dataX=XCornell[-c(1,2),],nt=3,dataPredictY=XCornell[c(1,2),],keepcoeffs=TRUE)
rm("XCornell","yCornell")

## With an incomplete dataset (X[1,2] is NA)
data(pine)
ypine <- pine[,11]
data(XpineNAX21)
PLS_v1_wvc(dataY=log(ypine)[-1],dataX=XpineNAX21[-1,],nt=3)
PLS_v1_wvc(dataY=log(ypine)[-1],dataX=XpineNAX21[-1,],nt=3,dataPredictY=XpineNAX21[1,])
PLS_v1_wvc(dataY=log(ypine)[-2],dataX=XpineNAX21[-2,],nt=3,dataPredictY=XpineNAX21[2,])
PLS_v1_wvc(dataY=log(ypine),dataX=XpineNAX21,nt=3)
rm("XpineNAX21","ypine")
}
\keyword{models}
\keyword{regression}
