% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_general.R
\name{phtest}
\alias{phtest}
\alias{phtest.formula}
\alias{phtest.panelmodel}
\title{Hausman Test for Panel Models}
\usage{
phtest(x, ...)

\method{phtest}{formula}(x, data, model = c("within", "random"),
  method = c("chisq", "aux"), index = NULL, vcov = NULL, ...)

\method{phtest}{panelmodel}(x, x2, ...)
}
\arguments{
\item{x}{an object of class \code{"panelmodel"} or \code{"formula"},}

\item{\dots}{further arguments to be passed on. For the formula method,
place argument \code{effect} here to compare e.g. twoway models
(\code{effect = "twoways"}) Note: Argument \code{effect} is not respected in
the panelmodel method.}

\item{data}{a \code{data.frame},}

\item{model}{a character vector containing the names of two models
(length(model) must be 2),}

\item{method}{one of \code{"chisq"} or \code{"aux"},}

\item{index}{an optional vector of index variables,}

\item{vcov}{an optional covariance function,}

\item{x2}{an object of class \code{"panelmodel"},}
}
\value{
An object of class \code{"htest"}.
}
\description{
Specification test for panel models.
}
\details{
The Hausman test (sometimes also called Durbin--Wu--Hausman test)
is based on the difference of the vectors of coefficients of two
different models.  The \code{panelmodel} method computes the original
version of the test based on a quadratic form
\insertCite{HAUS:78}{plm}. The \code{formula} method, if
\code{method="chisq"} (default), computes the original version of the
test based on a quadratic form; if \code{method="aux"} then the
auxiliary-regression-based version in Wooldridge (2010,
Sec. 10.7.3.) is computed instead \insertCite{@WOOL:10 Sec.10.7.3}{plm}.
Only the latter can be robustified by specifying a robust
covariance estimator as a function through the argument \code{vcov} (see
\strong{Examples}).

The equivalent tests in the \strong{one-way} case using a between
model (either "within vs. between" or "random vs. between")
\insertCite{@see @HAUS:TAYL:81 or @BALT:13 Sec.4.3}{plm} can also
be performed by \code{phtest}, but only for \code{test = "chisq"}, not for
the regression-based test. NB: These equivalent tests using the
between model do not extend to the two-ways case.  There are,
however, some other equivalent tests,
\insertCite{@see @KANG:85 or @BALT:13 Sec.4.3.7}{plm},
but those are unsupported by \code{phtest}.
}
\examples{

data("Gasoline", package = "plm")
form <- lgaspcar ~ lincomep + lrpmg + lcarpcap
wi <- plm(form, data = Gasoline, model = "within")
re <- plm(form, data = Gasoline, model = "random")
phtest(wi, re)
phtest(form, data = Gasoline)
phtest(form, data = Gasoline, method = "aux")

# robust Hausman test (regression-based)
phtest(form, data = Gasoline, method = "aux", vcov = vcovHC)

# robust Hausman test with vcov supplied as a
# function and additional parameters
phtest(form, data = Gasoline, method = "aux",
  vcov = function(x) vcovHC(x, method="white2", type="HC3"))

}
\references{
\insertRef{HAUS:78}{plm}

\insertRef{HAUS:TAYL:81}{plm}

\insertRef{KANG:85}{plm}

\insertRef{WOOL:10}{plm}

\insertRef{BALT:13}{plm}
}
\author{
Yves Croissant, Giovanni Millo
}
\keyword{htest}
