% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_objects.R
\name{plot_bbox}
\alias{plot_bbox}
\title{Add Bounding Boxes to an Existing Plot}
\usage{
plot_bbox(bbox_list, col = "red")
}
\arguments{
\item{bbox_list}{A list of bounding boxes, as returned by \code{object_bbox()}.}

\item{col}{The color for the bounding boxes. Defaults to \code{"red"}.}
}
\value{
None (adds bounding boxes to an existing plot).
}
\description{
This function overlays bounding boxes onto an existing plot.
}
\examples{
if(interactive()){
plot(NA,
    xlim = c(0, 200),
    ylim = c(0, 200),
    asp = 1)
contours <- list(
  matrix(c(10, 20, 30, 40, 50, 60, 70, 80, 90, 100,
           110, 120, 130, 140, 150, 160, 170, 180, 190, 200),
         ncol = 2, byrow = FALSE)
)
bbox_list <- object_bbox(contours)
plot_bbox(bbox_list)
}

}
