% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mapedit.R
\name{plot_index}
\alias{plot_index}
\title{Plot an image index}
\usage{
plot_index(
  img = NULL,
  object = NULL,
  index = NULL,
  remove_bg = TRUE,
  viewer = get_pliman_viewer(),
  all_layers = TRUE,
  layer = 1,
  max_pixels = 5e+05,
  downsample = NULL,
  downsample_fun = NULL,
  color_regions = custom_palette(),
  ncol = NULL,
  nrow = NULL,
  aspect_ratio = NA
)
}
\arguments{
\item{img}{An optional \code{Image} object or an object computed with
\code{\link[=image_index]{image_index()}}. If \code{object} is provided, then the input image is obtained
internally.}

\item{object}{An object computed with \code{\link[=analyze_objects_shp]{analyze_objects_shp()}}. By using this
object you can ignore \code{img}.}

\item{index}{The index to plot. Defaults to the index computed from the
\code{object} if provided. Otherwise, the \code{B} index is computed. See
\code{\link[=image_index]{image_index()}} for more details.}

\item{remove_bg}{Logical value indicating whether to remove the background
when \code{object} is provided. Defaults to \code{TRUE}.}

\item{viewer}{The viewer option. If not provided, the value is retrieved
using \code{\link[=get_pliman_viewer]{get_pliman_viewer()}}. This option controls the type of viewer to use
for interactive plotting. The available options are "base" and "mapview".
If set to "base", the base R graphics system is used for interactive
plotting. If set to "mapview", the mapview package is used. To set this
argument globally for all functions in the package, you can use the
\code{\link[=set_pliman_viewer]{set_pliman_viewer()}} function. For example, you can run
\code{set_pliman_viewer("mapview")} to set the viewer option to "mapview" for
all functions.}

\item{all_layers}{Render all layers when \code{img} is an object computed with
\code{\link[=image_index]{image_index()}} and \code{viewer = "mapview"}?.}

\item{layer}{The layer to plot when \code{img} is an object computed with
\code{\link[=image_index]{image_index()}} and \code{viewer = "mapview"}. Defaults to the first layer
(first index computed).}

\item{max_pixels}{integer > 0. Maximum number of cells to plot the index. If
\code{max_pixels < npixels(img)}, downsampling is performed before plotting the
index. Using a large number of pixels may slow down the plotting time.}

\item{downsample}{integer; for each dimension the number of
pixels/lines/bands etc that will be skipped; Defaults to \code{NULL}, which will
find the best downsampling factor to approximate the \code{max_pixels} value.}

\item{downsample_fun}{function; if given, downsampling will apply
\verb{downsample_fun`` } to each of the the subtiles.}

\item{color_regions}{The color palette for displaying index values. Default
is \code{\link[=custom_palette]{custom_palette()}}.}

\item{nrow, ncol}{The number of rows or columns in the plot grid. Defaults to
\code{NULL}, i.e., a square grid is produced.}

\item{aspect_ratio}{Numeric, giving the aspect ratio y/x. Defaults to \code{NA}.
See \code{\link[graphics:plot.window]{graphics::plot.window()}} for more details.}
}
\value{
None
}
\description{
Plot an image index
}
\examples{
if(interactive()){
# Example usage:
library(pliman)
img <- image_pliman("sev_leaf.jpg")
plot_index(img, index = "B")
}

}
