% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_segmentation.R
\name{object_label}
\alias{object_label}
\title{Labels objects}
\usage{
object_label(
  img,
  index = "B",
  invert = FALSE,
  fill_hull = FALSE,
  threshold = "Otsu",
  k = 0.1,
  windowsize = NULL,
  filter = FALSE,
  watershed = FALSE,
  tolerance = NULL,
  extension = NULL,
  object_size = "medium",
  plot = TRUE,
  ncol = NULL,
  nrow = NULL,
  verbose = TRUE
)
}
\arguments{
\item{img}{An image object.}

\item{index}{A character value (or a vector of characters) specifying the
target mode for conversion to binary image. See the available indexes with
\code{\link[=pliman_indexes]{pliman_indexes()}} and \code{\link[=image_index]{image_index()}} for more details.}

\item{invert}{Inverts the binary image, if desired.}

\item{fill_hull}{Fill holes in the objects? Defaults to \code{FALSE}.}

\item{threshold}{The theshold method to be used.
\itemize{
\item By default (\code{threshold = "Otsu"}), a threshold value based
on Otsu's method is used to reduce the grayscale image to a binary image. If
a numeric value is informed, this value will be used as a threshold.
\item If \code{threshold = "adaptive"}, adaptive thresholding (Shafait et al. 2008)
is used, and will depend on the \code{k} and \code{windowsize} arguments.
\item If any non-numeric value different than \code{"Otsu"} and \code{"adaptive"} is used,
an iterative section will allow you to choose the threshold based on a
raster plot showing pixel intensity of the index.
}}

\item{k}{a numeric in the range 0-1. when \code{k} is high, local threshold
values tend to be lower. when \code{k} is low, local threshold value tend to be
higher.}

\item{windowsize}{windowsize controls the number of local neighborhood in
adaptive thresholding. By default it is set to \code{1/3 * minxy}, where
\code{minxy} is the minimum dimension of the image (in pixels).}

\item{filter}{Performs median filtering in the binary image? (Defaults to
\code{FALSE}). Provide a positive integer > 1 to indicate the size of the median
filtering. Higher values are more efficient to remove noise in the
background but can dramatically impact the perimeter of objects, mainly for
irregular perimeters such as leaves with serrated edges.}

\item{watershed}{If \code{TRUE} (default) performs watershed-based object
detection. This will detect objects even when they are touching one other.
If \code{FALSE}, all pixels for each connected set of foreground pixels are set
to a unique object. This is faster but is not able to segment touching
objects.}

\item{tolerance}{The minimum height of the object in the units of image
intensity between its highest point (seed) and the point where it contacts
another object (checked for every contact pixel). If the height is smaller
than the tolerance, the object will be combined with one of its neighbors,
which is the highest.}

\item{extension}{Radius of the neighborhood in pixels for the detection of
neighboring objects. Higher value smooths out small objects.}

\item{object_size}{The size of the object. Used to automatically set up
\code{tolerance} and \code{extension} parameters. One of the following. \code{"small"}
(e.g, wheat grains), \code{"medium"} (e.g, soybean grains), \code{"large"}(e.g, peanut
grains), and \code{"elarge"} (e.g, soybean pods)`.}

\item{plot}{Show image after processing?}

\item{nrow, ncol}{The number of rows or columns in the plot grid. Defaults to
\code{NULL}, i.e., a square grid is produced.}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}
}
\value{
A list with the same length of \code{img} containing the labeled objects.
}
\description{
All pixels for each connected set of foreground (non-zero) pixels in x are
set to an unique increasing integer, starting from 1. Hence, max(x) gives the
number of connected objects in x. This is a wrapper to \link[EBImage:bwlabel]{EBImage::bwlabel} or
\link[EBImage:watershed]{EBImage::watershed} (if \code{watershed = TRUE}).
}
\examples{
img <- image_pliman("soybean_touch.jpg")
# segment the objects using the "B" (blue) band.
object_label(img, index = "B")
object_label(img, index = "B", watershed = TRUE)
}
