\name{playState}
\alias{playState}
\title{Object representing the plot, window and device.}
\description{
  This object is used by \code{\link{playwith}} to 
  represent the state of the plot, window and device.
  The playState object is central to the \link{playwith.API}.
  However, it may also be seen by users controlling the "device" with
  \code{\link{playDevCur}}, \code{\link{playDevList}} etc.
}
\details{
A playState object is actually an \code{\link{environment}} containing many other objects.
It will always contain:
	\describe{
		\item{\code{win}}{
			the plot window (\code{\link[RGtk2]{gtkWindow}}).
		}
		\item{\code{dev}}{
			the plot device, as returned by \code{dev.cur}.
		}
		\item{\code{call}}{
			the current plot call.
		}
		\item{\code{env}}{
			local environment used to store evaluated plot call arguments.
		}
		\item{\code{is.lattice}}{
			whether the current plot is a Lattice plot.
		}
		\item{\code{viewport}}{
			a named list of viewport paths (or names).
			One of these must be named "plot".
			\code{NULL} if the plot is a base graphics or Lattice plot.
		}
		\item{\code{labels}}{
			labels for data points, either given or guessed.
		}
		\item{\code{data.points}}{
			given data points or \code{NULL}.
		}
		\item{\code{time.mode}}{
			whether time mode is active (horizontal scroll bar).
		}
		\item{\code{ids}}{
			a named list of currently labelled data points.
			Each name corresponds to a "space", which can be "page" 
			(positioned on page) or "plot" (positioned in plot coordinates).
			With Lattice graphics the space can be "packet 1" etc.
			The numeric vector in each list element gives the indices 
			of currently identified points in that space.
		}
		\item{\code{annotations}}{
			a named list of calls.
			Each name corresponds to a "space", as in \code{ids}.
		}
		\item{\code{brushed}}{
			a named list of currently brushed data points.
		}
		\item{\code{tools}}{
			a list of the widgets generated by the tool constructors.
		}
		\item{\code{widgets}}{
			A list of the GUI widgets. The only one that might be useful
			is \code{drawingArea} (the plot device itself).
			\preformatted{
drawingArea
topToolbar 
leftToolbar
bottomToolbar
rightToolbar
callToolbar
callEntry
undoButton
redoButton
pageEntry
pageScrollbar
pageScrollBox
timeEntry
timeScrollbar
timeScrollBox
promptBox
promptLabel
vbox
hbox
			}
		}
		\item{\code{plot.ready}}{
			whether the plot has been drawn and is ready for interaction.
		}
		\item{\code{trellis}}{
			the trellis object corresponding to the current plot,
			if it is a Lattice plot.
		}
	}
	
	Miscellaneous elements include:
	\code{page, pages, time.vector, cur.index, on.close, 
	.args, deviceToSpace, baseViewports}.
	
	Other objects can be passed in through the \code{...} argument to 
	\code{\link{playwith}}, or defined by tools.

}
\author{ Felix Andrews \email{felix@nfrac.org} }
\seealso{ \code{\link{playwith}}, \link{playwith.API} }

\keyword{ programming }

