\name{pkgndep}
\alias{pkgndep}
\title{
Package dependency analysis
}
\description{
Package dependency analysis
}
\usage{
pkgndep(package, load = FALSE, verbose = TRUE, online = TRUE)
}
\arguments{

  \item{package}{Package name. The value should be 1. a CRAN/Bioconductor package, 2. an installed package, 3. a path of a local package, 4. URL of a GitHub repository.}
  \item{load}{Check which other packages are loaded into R session (directly or indirectly) when loading \code{pkg}. }
  \item{verbose}{Whether to show messages.}
  \item{online}{If the value is \code{TRUE}, it will directly use the package database file from CRAN/Bioconductor. If the  value is \code{FALSE}, it uses the cached package database retrieved on 2021-10-28.}

}
\details{
The package database for dependency analysis is always directly retrieved from CRAN/Bioconductor.
}
\value{
A \code{pkgndep} object.
}
\examples{
\dontrun{
x = pkgndep("ComplexHeatmap")
}
# The `x` variable generated by `pkgndep()` is already saved in this package.
x = readRDS(system.file("extdata", "ComplexHeatmap_dep.rds", package = "pkgndep"))
x
dependency_heatmap(x)
}
