% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pack.R
\name{pack}
\alias{pack}
\title{Pack packages into a text file}
\usage{
pack(..., output, quiet = FALSE)
}
\arguments{
\item{...}{One or more file collection objects
generated by \code{\link[=collate]{collate()}}.}

\item{output}{Path to the output text file.
If empty, will create a txt file using the lower-cased package name
in the current working directory. For multiple packages,
will use \code{"pkglite.txt"}.}

\item{quiet}{Suppress printing of progress?}
}
\value{
The output file path.
}
\description{
Pack packages into a text file
}
\section{Specification}{

\if{latex}{
  \itemize{
    \item Get the package metadata, for example, package names, from the
    input file collection(s).
    \item If unspecified, generate a default output file name by the
    number of packages.
    \item Read each file in each package as DCF blocks.
    \item Add header and write to the output file.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
# pack two packages
pkg1 <- system.file("examples/pkg1", package = "pkglite")
pkg2 <- system.file("examples/pkg2", package = "pkglite")

fc1 <- pkg1 \%>\% collate(file_default())
fc2 <- pkg2 \%>\% collate(file_default())

txt <- tempfile(fileext = ".txt")
pack(fc1, fc2, output = txt, quiet = TRUE)

txt \%>\%
  readLines() \%>\%
  head() \%>\%
  cat(sep = "\n")
txt \%>\%
  readLines() \%>\%
  length()
}
