% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PivotCalculator.R
\docType{class}
\name{PivotCalculator}
\alias{PivotCalculator}
\title{A class that computes the value of a cell.}
\format{\code{\link{R6Class}} object.}
\usage{
PivotCalculator
}
\value{
Object of \code{\link{R6Class}} with properties and methods that help
  calculate the value of a pivot table cell.
}
\description{
The PivotCalculator class has various functions and methods that assist with
calculating the value of a cell in a pivot table.
}
\section{Fields}{

\describe{
\item{\code{parentPivot}}{Owning pivot table.}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For more complete explanations and examples please see
  the extensive vignettes supplied with this package.}
  \item{\code{new(...)}}{Create a new pivot table calculator, specifying the
  field value documented above.}

  \item{\code{getDataFrame(dataName)}}{Gets a data frame with the specified
  name from the data frames added to the pivot table.}
  \item{\code{getCalculationGroup(calculationGroupName)}}{Gets a calculation
  group with the specified name from the calculation groups added to the
  pivot table.}
  \item{\code{getCalculation(calculationGroupName, calculationName)}}{Gets a
  calculation with the specified name and group from the calculation groups
  added to the pivot table.}
  \item{\code{newFilter(variableName, values)}}{Creates a new PivotFilter
  object associated with the specified data frame column name and column
  values.}
  \item{\code{newFilters(variableName, values)}}{Creates a new PivotFilters
  object associated with the specified data frame column name and column
  values.}
  \item{\code{setFilters(filters1, filters2, action="replace")}}{Combines two
  PivotFilters objects (e.g. to intersect the filters coming from the row and
  column headings for a particular cell).}
  \item{\code{setFilterValues(filters, variableName, values,
  action="replace")}}{Updates a PivotFilters object based on a PivotFilter
  object (e.g. to union the filter criteria arising from multiple row
  headers).}
  \item{\code{getFilteredDataFrame(dataFrame, filters)}}{Applies a
  PivotFilters object to a data frame, returning a new data frame.}
  \item{\code{getDistinctValues(dataFrame, variableName)}}{Gets the distinct
  values from the specified column of a data frame.}
  \item{\code{formatValue(value, format)}}{Formats a numerical value using
  either an sprintf string, a list of arguments for the base::format()
  function or using a custom R function.}
  \item{\code{getSingleValue(dataFrame, valueName)}}{Gets a single value from
  a data frame.  Essentially the same as the getSummaryValue() function but
  with no aggregation.}
  \item{\code{getSummaryValue(dataFrame, summaryName,
  summariseExpression)}}{Aggregates a data frame using the dplyr::summarise()
  function to calculate and return an aggregate value.}
  \item{\code{evaluateSingleValue(dataFrame, rowColFilters, calcFilters,
  valueName, format, noDataValue, noDataCaption)}}{A wrapper for
  getSingleValue() which performs filtering and handles edge cases.}
  \item{\code{evaluateSummariseExpression(dataFrame, rowColFilters,
  calcFilters, summaryName, summariseExpression, format, noDataValue,
  noDataCaption)}}{A wrapper for getSummaryValue() which performs filtering
  and handles edge cases.}
  \item{\code{evaluateCalculationExpression(values, calculationExpression,
  format, noDataValue, noDataCaption)}}{Evaluates an R expression in order to
  combine the results of other calculations.}
  \item{\code{evaluateCalculateFunction(rowColFilters, calcFilters,
  calculationFunction, format, baseValues, cell)}}{Invokes a user-provided
  custom R function to aggregate data and perform calculations.}
  \item{\code{evaluateNamedCalculation(calculationName, calculationGroupName,
  rowColFilters, cell)}}{Invokes the relevant calculation function above
  based upon the calculation type.}
  \item{\code{evaluateCell(cell)}}{Top-level calculation function responsible
  for calculating the value of a pivot table cell.}
}
}

\examples{
# This class should only be created by the pivot table.
# It is not intended to be created outside of the pivot table.
}
\keyword{datasets}
