% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wth_d.R
\name{wth_d}
\alias{wth_d}
\title{Derive the wall thickness depending on the outside diameter of pipe}
\usage{
wth_d(x)
}
\arguments{
\item{x}{outside diameter of pipe, [\emph{mm}]. Type: \code{\link{assert_double}}.}
}
\description{
Use \href{https://docs.cntd.ru/document/1200174717}{GOST 30732}
specifications to derive the value of the pipe wall thickness if only its
diameter is known for the pipe.
}
\details{
Utility should be used only in cases where the actual value
of the pipe wall thickness cannot be determined by any
other means. In many cases internal diameter may be used instead of outside
one without significant loss in precision. The wall thickness value is
derived only for the diameters mentioned in
\href{https://docs.cntd.ru/document/902148459}{Minenergo Order 325}.

Unfortunately, the inverse function cannot be constructed in any reliable way
due to significant ambiguity.
}
\examples{
 library(pipenostics)

 # Guess pipe widths for some frequently met diameters
 wth_d(as.double(c(57, 76, 89)))

 # [1]  3  7 11  # [mm]

}
\references{
\href{https://docs.cntd.ru/document/1200174717}{GOST 30732}.
  \emph{Steel pipes and shaped products with foamed polyurethane thermal
  insulation in protective sheath. Specifications.}
}
\seealso{
Other utils: 
\code{\link{geoarea}()},
\code{\link{meteos}()},
\code{\link{mgtdhid}()}
}
\concept{utils}
