% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropt.R
\name{dropt}
\alias{dropt}
\title{Temperature drop in cylindrical steel pipe due heat loss}
\usage{
dropt(
  temperature = 130,
  pressure = mpa_kgf(6),
  flow_rate = 250,
  loss_power = 7000
)
}
\arguments{
\item{temperature}{temperature of heat carrier (water) inside the pipe measured at the
inlet of pipe, [\emph{°C}]. Type: \code{\link{assert_double}}.}

\item{pressure}{\href{https://en.wikipedia.org/wiki/Pressure_measurement#Absolute}{absolute pressure}
of heat carrier (water) inside the pipe, [\emph{MPa}]. Type: \code{\link{assert_double}}.}

\item{flow_rate}{amount of heat carrier (water) that is transferred by pipe during a period,
[\emph{ton/hour}]. Type: \code{\link{assert_double}}.}

\item{loss_power}{power of heat loss - heat loss through area of pipe wall per hour, [\emph{kcal/hour}].
Type: \code{\link{assert_double}}.}
}
\value{
temperature drop at the outlet of pipe, [\emph{°C}]. Type: \code{\link{assert_double}}.
}
\description{
Calculate temperature drop in steel pipe of \emph{district heating system}
 (where water is a heat carrier) that is a result of heat loss through
 pipe wall and insulation.
}
\details{
Specific isobaric \href{https://en.wikipedia.org/wiki/Heat_capacity}{heat capacity}
  used in calculations is calculated according to
  \href{http://www.iapws.org/relguide/IF97-Rev.pdf}{IAPWS R7-97(2012)}
  for \strong{Region 1} since it is assumed that state of water in
  \emph{district heating system} is always in that region.
}
\examples{
 library(pipenostics)

 # Calculate normative temperature drop based on Minenergo-325 for pipe segment
 pipeline <- list(
   year   = 1968,
   laying = "channel",
   d      = 700, # [mm]
   len    = 1000 # [m]
 )

 regime <- list(
   temperature = c(130, 150), # [°C]
   pressure    = .588399,     # [MPa]
   flow_rate   = 250          # [ton/hour]
 )

 pipe_loss_power <- do.call(
     m325nhl,
     c(pipeline, temperature = list(regime[["temperature"]]), duration = 1)  # [kcal/hour]
 )

 temperature_drop <- dropt(
   temperature = regime[["temperature"]], # [°C]
   loss_power  = pipe_loss_power          # [kcal/hour]
 )                                        # [°C]

 print(temperature_drop)

 # [1] 1.366806 1.433840
}
\seealso{
Other district heating: 
\code{\link{dropg}()},
\code{\link{dropp}()}
}
\concept{district heating}
