% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cbind_fast}
\alias{cbind_fast}
\title{Faster alternative to \code{cbind_fast}}
\usage{
cbind_fast(df1, df2)
}
\arguments{
\item{df1}{A data.frame.}

\item{df2}{Another data.frame}
}
\value{
A data.frame equal to \code{df1} with the columns of \code{df2} appended.
}
\description{
This is not as 'safe' as using \code{cbind_fast} - for example, if \code{df1} has columns with the
same name as columns in \code{df2}, then they will be over-written.
}
\examples{
\dontrun{
df1 <- data.frame(x = 1:5, y = 1:5 * 0.1)
df2 <- data.frame(a = 6:10, b = 6:10 * 0.25)
df3 <- cbind_fast(df1, df2)
df3
#   x   y  a    b
# 1 1 0.1  6 1.50
# 2 2 0.2  7 1.75
# 3 3 0.3  8 2.00
# 4 4 0.4  9 2.25
# 5 5 0.5 10 2.50
}
}

