% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin_confint.R
\name{pin_confint}
\alias{pin_confint}
\title{PIN confidence intervals}
\usage{
pin_confint(param = NULL, numbuys = NULL, numsells = NULL,
  lower = rep(0, 5), upper = c(1, 1, rep(Inf, 3)), n = 10000,
  seed = NULL, level = 0.95, ncores = detectCores())
}
\arguments{
\item{param}{\emph{numeric}: (named) vector of model parameters
(valid names: \code{'alpha'}, \code{'delta'}, \code{'epsilon_b'}, \code{'epsilon_s'}, \code{'mu'}),
length must equal 5}

\item{numbuys}{\emph{numeric} vector of daily buys}

\item{numsells}{\emph{numeric} vector of daily sells}

\item{lower}{\emph{numeric} lower bounds for optimization, must have length of 5}

\item{upper}{\emph{numeric} upper bounds for optimization, must have length of 5}

\item{n}{\emph{integer}: Number of simulation runs, defaults to 10000}

\item{seed}{\emph{interpretted as integer}: setting seed for RNG, defaults to \code{NULL}; for more detail see
\code{\link[base]{set.seed}}}

\item{level}{\emph{numeric}: Confidence level, defaults to 0.95}

\item{ncores}{\emph{integer}: Number of cpu cores utilized in computation, defaults to \code{\link[parallel]{detectCores}}}
}
\value{
\emph{numeric}: confidence interval
}
\description{
Computes confidence intervals for the probability of informed trading by simulation
}
\details{
If names are not set for \code{param} or one or more of the vector names do not match the valid choices, they are internally set to
\code{'alpha'}, \code{'delta'}, \code{'epsilon_b'}, \code{'epsilon_s'}, \code{'mu'} (in this order). \cr
The \pkg{foreach}, \pkg{doParallel} and \pkg{parallel} packages are utilized for computation of confidence intervals in parallel.
By default, \code{ncores} is set to \code{\link[parallel]{detectCores}} which attempts to utilize all available cores for computation.
This task may be slow and time-consuming on older or single-core machines.
}

