% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-PI.r
\name{bootPI}
\alias{bootPI}
\title{A parametric bootstrap prediction interval (Nagashima et al., 2018)}
\usage{
bootPI(y, sigma, alpha = 0.05, B = 25000, maxit1 = 1e+05,
  eps = 10^(-10), lower = 0, upper = 1000, maxit2 = 1000,
  tol = .Machine$double.eps^0.25)
}
\arguments{
\item{y}{the effect size estimates vector}

\item{sigma}{the within studies variances vector}

\item{alpha}{the alpha level of the prediction interval}

\item{B}{the number of bootstrap samples}

\item{maxit1}{the maximum number of iteration for the exact distribution function of \eqn{Q}}

\item{eps}{the desired level of accuracy for the exact distribution function of \eqn{Q}}

\item{lower}{the lower limit of random numbers of \eqn{\tau^2}}

\item{upper}{the lower upper of random numbers of \eqn{\tau^2}}

\item{maxit2}{the maximum number of iteration for numerical inversions}

\item{tol}{the desired level of accuracy for numerical inversions}
}
\value{
The average treatment effect estimate \eqn{\hat{\mu}} (\code{muhat}),
and the lower and upper prediction limits \eqn{\hat{c}_l} (\code{lbpi}) and \eqn{\hat{c}_u} (\code{ubpi}).
}
\description{
A parametric bootstrap prediction interval (Nagashima et al., 2018)
}
\examples{
data(sbp, package = "pimeta")
set.seed(20161102)
\donttest{
  pimeta::bootPI(sbp$y, sbp$sigmak, B = 50000)
}
# $muhat
# [1] -0.3340597
# $lbpi
# [1] -0.8768976
# $ubpi
# [1] 0.2248231
}
\references{
Nagashima, K., Noma, H., and Furukawa, T. A. (2018).
Prediction intervals for random-effects meta-analysis:
a confidence distribution approach.
\emph{Under Review}.
\url{https://arxiv.org/abs/1804.01054}.
}
