% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\docType{methods}
\name{coef}
\alias{coef}
\alias{coef,pim-method}
\alias{coef,pim.summary-method}
\title{Extract the coefficients from a pim or pim.summary object}
\usage{
coef(object, ...)

\S4method{coef}{pim}(object, ...)

\S4method{coef}{pim.summary}(object, ...)
}
\arguments{
\item{object}{a \code{pim} or \code{pim.summary} object}

\item{...}{currently ignored.}
}
\value{
a named vector with the coefficients.
}
\description{
This function works like \code{\link[stats]{coef}} from the \code{stats}
package. It extracts the coefficients from the objects.
}
\examples{
data("FEVData")
Model <- pim(FEV~ Age + Smoke*Sex , data=FEVData)
coef(Model)
summ <- summary(Model)
coef(summ)

}

