% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_cluster.R
\name{ighvDistance}
\alias{ighvDistance}
\title{Germline set alleles distance}
\usage{
ighvDistance(germline_set, AA = FALSE)
}
\arguments{
\item{germline_set}{A character list of the IMGT aligned IGHV allele sequences. See details for curating options.}

\item{AA}{Logical (FALSE by default). If to calculate the distance based on the amino acid sequences.}
}
\value{
A \code{matrix} of the computed distances between the alleles pairs.
}
\description{
Calculates the distance between pairs of alleles based on their aligned germline sequences.
The function assume the germline set sequence are at an even length.
If not the function will pad the sequences with to the longest sequence length with Ns.
}
\details{
The aligned IMGT IGHV allele germline set can be download from the IMGT site \url{https://www.imgt.org/} under the section genedb.
}
