% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_release_create.R
\name{pb_release_create}
\alias{pb_release_create}
\alias{pb_new_release}
\title{Create a new release on GitHub repo}
\usage{
pb_release_create(
  repo = guess_repo(),
  tag,
  commit = NULL,
  name = tag,
  body = "Data release",
  draft = FALSE,
  prerelease = FALSE,
  .token = gh::gh_token()
)
}
\arguments{
\item{repo}{Repository name in format "owner/repo". Will guess
the current repo if not specified.}

\item{tag}{tag to create for this release}

\item{commit}{Specifies the commit-ish value that
determines where the Git tag is created from.
Can be any branch or full commit SHA (not the short hash). Unused if the
git tag already exists. Default: the repository's
default branch (usually \code{master}).}

\item{name}{The name of the release. Defaults to tag.}

\item{body}{Text describing the contents of the tag.
default text is "Data release".}

\item{draft}{default \code{FALSE}. Set to \code{TRUE} to create
a draft (unpublished) release.}

\item{prerelease}{default \code{FALSE}. Set to \code{TRUE} to
identify the release as a pre-release.}

\item{.token}{GitHub authentication token, see \verb{[gh::gh_token()]}}
}
\description{
Create a new release on GitHub repo
}
\examples{
\dontrun{
pb_release_create("cboettig/piggyback-tests", "v0.0.5")
}
}
\seealso{
Other release_management: 
\code{\link{pb_release_delete}()}
}
\concept{release_management}
