% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_cfg.R
\name{pp_cfg}
\alias{pp_cfg}
\alias{is_pp_cfg}
\alias{as_pp_cfg}
\title{Configuration list R6 object}
\usage{
pp_cfg(cfg = list())

is_pp_cfg(cfg)

as_pp_cfg(cfg = list())
}
\arguments{
\item{cfg}{List of configuration options}
}
\description{
\code{pp_cfg()} and \code{as_pp_cfg()} create piecepack configuration list R6 objects.
\code{is_pp_cfg()} returns \code{TRUE} if object is a piecepack configuration list R6 object.
\code{as.list()} will convert it into a list.
}
\details{
\code{pp_cfg} R6 class objects serve the following purposes:
\itemize{
\item Customize the appearance of pieces drawn by \code{grid.piece()}.
\item Speed up the drawing of graphics through use of caching.
\item Allow the setting and querying of information about the board game components
that maybe of use to developers:
\itemize{
\item Number of suits
\item Number of ranks
\item Suit colors
\item Which types of components are included and/or properly supported
\item What would be a good color to use when adding annotations on top of these components.
\item Title, Description, Copyright, License, and Credit metadata
}
}
}
\section{\code{pp_cfg} R6 Class Method Arguments}{
\describe{
\item{\code{piece_side}}{A string with piece and side separated by a underscore e.g. "coin_face".}
\item{\code{suit}}{Number of suit (starting from 1).}
\item{\code{rank}}{Number of rank (starting from 1).}
\item{\code{type}}{Which type of grob to return, either \code{"normal"}, \code{"picture"}, \code{"raster"}, or \code{"transformation"}.}
\item{\code{scale}}{"scale" factor}
\item{\code{alpha}}{"alpha" value}
}
}

\section{\code{pp_cfg} R6 Class Methods}{
\describe{
\item{\code{get_grob()}}{Returns a \code{grid} \dQuote{grob} for drawing the piece.}
\item{\code{get_piece_opt()}}{Returns a list with info useful for drawing the piece.}
\item{\code{get_suit_color()}}{Returns the suit colors.}
\item{\code{get_width()}, \code{get_height()}, \code{get_depth()}}{
Dimensions (of the bounding cube) of the piece in inches}
}
}

\section{\code{pp_cfg} R6 Class Fields and Active Bindings}{
\describe{
\item{\code{annotation_color}}{Suggestion of a good color to annotate with}
\item{\code{cache}}{Cache object which stores intermediate graphical calculations.
Default is a memory-cache that does not prune.
This can be replaced by another cache that
implements the cache API used by the \code{cachem} package}
\item{\code{cache_grob}}{Whether we should cache (2D) grobs}
\item{\code{cache_grob_with_bleed_fn}}{Whether we should cache the grob with bleed functions}
\item{\code{cache_piece_opt}}{Whether we should cache piece opt information}
\item{\code{cache_op_fn}}{Whether we should cache the oblique projection functions}
\item{\code{cache_obj_fn}}{Whether we should cache any 3D rendering functions}
\item{\code{copyright}}{Design copyright information}
\item{\code{credit}}{Design credits}
\item{\code{description}}{Design description}
\item{\code{fontfamily}}{Main font family}
\item{\code{has_bits}}{Whether we should assume this supports "bit" pieces}
\item{\code{has_boards}}{Whether we should assume this supports "board" pieces}
\item{\code{has_cards}}{Whether we should assume this supports "card" pieces}
\item{\code{has_coins}}{Whether we should assume this supports "coin" pieces}
\item{\code{has_dice}}{Whether we should assume this supports "die" pieces}
\item{\code{has_matchsticks}}{Whether we should assume this supports "matchstick" pieces}
\item{\code{has_pawns}}{Whether we should assume this supports "pawn" pieces}
\item{\code{has_piecepack}}{Binding which simultaneously checks/sets
\code{has_coins}, \code{has_tiles}, \code{has_pawns}, \code{has_dice}}
\item{\code{has_pyramids}}{Whether we should assume this supports "pyramid" pieces}
\item{\code{has_saucers}}{Whether we should assume this supports "saucer" pieces}
\item{\code{has_tiles}}{Whether we should assume this supports "tile" pieces}
\item{\code{spdx_id}}{SPDX Identifier for graphical design license.
See \url{https://spdx.org/licenses/} for full list.}
\item{\code{title}}{Design title}
}
}

\section{Defunct \code{pp_cfg} R6 Class attributes which have been removed}{
\describe{
\item{\code{cache_shadow}}{Use \code{cache_op_fn} instead}
\item{\code{i_unsuit}}{Instead add \code{1L} to \code{n_suits}}
\item{\code{get_pictureGrob()}}{Use \code{get_grob(..., type = "picture")} instead}
\item{\code{get_shadow_fn}}{\code{get_op_grob()} returns complete oblique projection grob}
}
}

\examples{
 cfg <- pp_cfg(list(invert_colors=TRUE))
 as.list(cfg)
 is_pp_cfg(cfg)
 as_pp_cfg(list(suit_color="darkred,black,darkgreen,darkblue,grey"))
 cfg$get_suit_color(suit=3)
 cfg$annotation_color
 cfg$has_matchsticks
 cfg$has_matchsticks <- TRUE
 cfg$has_matchsticks
 cfg$get_width("tile_back")
 cfg$get_height("die_face")
 cfg$get_depth("coin_face")
 \donttest{
   cfg <- list()
   system.time(replicate(100, grid.piece("tile_face", 4, 4, cfg)))
   cfg <- pp_cfg(list())
   system.time(replicate(100, grid.piece("tile_face", 4, 4, cfg)))
 }

}
\seealso{
\code{\link[=game_systems]{game_systems()}} for functions that return configuration list
objects for several game systems.
\url{https://trevorldavis.com/piecepackr/configuration-lists.html} for more details
about \code{piecepackr} configuration lists.
}
