#' @title Routines for scientific research
#'
#' @description Collection of routines for efficient scientific computations, as needed in research in physics and astrophysics. These can be used for random number generation (e.g. from spherical and custom distributions), information and entropy analysis (e.g. used in Obreschkow et al. (2020) <doi:10.1093/mnras/staa445>), spatial statistics, such as special DFTs and Landy-Szalay estimators (Landy & Szalay (1993) <doi:10.1086/172900>), binning/gridding of point sets and 2D interpolation, Monte Carlo integration, vector arithmetics, coordinate transformations, unit conversions and cosmological distance calculations. Also includes a list of important physical constants, particularly useful in astrophysics.
#'
#' @author Danail Obreschkow
#'
#' @docType package
#' @name physx
#' @useDynLib physx
NULL
