% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barPhylo.R
\name{dotplot.phylo4d}
\alias{dotplot.phylo4d}
\title{Dotplot of Traits Values along a Phylogeny}
\usage{
\method{dotplot}{phylo4d}(p4d, trait = names(tdata(p4d)),
  center = TRUE, scale = TRUE, tree.ladderize = FALSE,
  tree.type = "phylogram", tree.ratio = NULL, tree.xlim = NULL,
  tree.open.angle = 0, tree.open.crown = TRUE, show.tip = TRUE,
  tip.labels = NULL, tip.col = "black", tip.cex = 1, tip.font = 3,
  tip.adj = 0, data.xlim = NULL, show.data.axis = TRUE,
  dot.col = "black", dot.pch = 20, dot.cex = 2, show.trait = TRUE,
  trait.labels = NULL, trait.col = "black", trait.cex = 1,
  trait.font = 1, trait.bg.col = "grey90", error.bar.sup = NULL,
  error.bar.inf = NULL, error.bar.col = 1, show.box = FALSE,
  grid.vertical = FALSE, grid.horizontal = TRUE, grid.col = "grey25",
  grid.lty = "dashed", ...)
}
\arguments{
\item{p4d}{a \code{phylo4d} object.}

\item{trait}{the traits in the \code{phylo4d} object to include in the plot.
Can be a character vector giving the name of the traits or numbers giving the column index
in the table of the data slot of the p4d object. Can be used to reorder the traits in the plot.}

\item{center}{a logical indicating whether traits values should be centered.}

\item{scale}{a logical indicating whether traits values should be scaled.}

\item{tree.ladderize}{a logical indicating whether the tree should be (right) ladderized.}

\item{tree.type}{a character string specifying the type of phylogeny to be drawn.
Can be "\code{phylogram}", "\code{cladogram}" or "\code{fan}".}

\item{tree.ratio}{a numeric value in [0, 1] giving the proportion of width of the figure for the tree.}

\item{tree.xlim}{a numeric vector of length 2 giving the limits of the x-axis for the tree. If \code{NULL},
it is determined automatically.}

\item{tree.open.angle}{a numeric value giving the angle in degrees left blank if \code{tree.type = "fan"}.}

\item{tree.open.crown}{a logical indicating whether the crowns should be drawn following the value
of \code{tree.open.angle} (default \code{TRUE}).}

\item{show.tip}{logical indicating whether tips labels should be drawn.}

\item{tip.labels}{character vector to label the tips.
If \code{NULL} the tips labels of the \code{phylo4d} object are used}

\item{tip.col}{a vector of R colors to use for the tips labels.
Recycled if necessary.}

\item{tip.cex}{a numeric vector to control character size of the tips labels.
Recycled if necessary.}

\item{tip.font}{an integer vector specifying the type of font for the tips labels:
1 (plain text), 2 (bold), 3 (italic), or 4 (bold italic). Recycled if necessary.}

\item{tip.adj}{a vector of numeric in [0, 1] to control tips labels justification:
0 (left-justification), 0.5 (centering), or 1 (right-justification). Recycled if necessary.}

\item{data.xlim}{numeric vector of length 2 or matrix giving the x coordinates range for
the barplots/dotplots (see Details).}

\item{show.data.axis}{logical indicating whether barplots/dotplots axes should be drawn.}

\item{dot.col}{a vector of R colors to use for the points.
Recycled along the tips, reapeated for each trait.
The user can also provide a matrix for a finer tuning (see Details)}

\item{dot.pch}{a numerical vector of symbol to use for the points.
Recycled along the tips, reapeated for each trait.
The user can also provide a matrix for a finer tuning (see Details)}

\item{dot.cex}{a numerical vector. Character (or symbol) expansion for the points.
Recycled along the tips, reapeated for each trait.
The user can also provide a matrix for a finer tuning (see Details)}

\item{show.trait}{logical indicating whether traits labels should be drawn.}

\item{trait.labels}{character vector to label the traits.
If \code{NULL} the traits labels of the \code{phylo4d} object are used.}

\item{trait.col}{a vector of R colors to use for the traits labels.
Recycled if necessary.}

\item{trait.cex}{a numeric vector to control character size of the trait labels.
Recycled if necessary.}

\item{trait.font}{an integer vector specifying the type of font for the traits labels:
1 (plain text), 2 (bold), 3 (italic), or 4 (bold italic). Recycled if necessary.}

\item{trait.bg.col}{a vector of R colors to use for the background of the barplots.
Recycled if necessary.}

\item{error.bar.sup}{a matrix giving the superior limit for error bars.
Columns and rows names must match with traits and tips labels, respectively.}

\item{error.bar.inf}{a matrix giving the inferior limit for error bars.
Columns and rows names must match with traits and tips labels, respectively.}

\item{error.bar.col}{a vector of R colors to use for the bars.
Recycled along the tips, reapeated for each trait.
The user can also provide a matrix for a finer tuning (see Details)}

\item{show.box}{a logical indicating whether a box should be drawn around the plots.}

\item{grid.vertical}{a logical incating whether vertical lines of the grid should be drawn.}

\item{grid.horizontal}{a logical incating whether horizontal lines of the grid should be drawn.}

\item{grid.col}{a vector of R colors to use for the lines of the grid.}

\item{grid.lty}{the lines type of the grid. Possibly a vector.}

\item{...}{further arguments to be passed to \code{plot.phylo}.}
}
\description{
Dotplot of Traits Values along a Phylogeny
}
\examples{
data(navic)
dotplot(navic)

}
