% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylosamp_funcs.R
\name{samplesize}
\alias{samplesize}
\title{Calculate sample size}
\usage{
samplesize(eta, chi, N, R = NULL, phi, min_pairs = 1, assumption = "mtml")
}
\arguments{
\item{eta}{scalar or vector giving the sensitivity of the linkage criteria}

\item{chi}{scalar or vector giving the specificity of the linkage criteria}

\item{N}{scalar or vector giving the final outbreak size}

\item{R}{scalar or vector giving the effective reproductive number of the pathogen}

\item{phi}{scalar or vector giving the desired true discovery rate (1-false discovery rate)}

\item{min_pairs}{minimum number of linked pairs observed in the sample, defaults to 1 pair (2 samples); this is to ensure reasonable results are obtained}

\item{assumption}{a character vector indicating which assumptions about transmission and linkage criteria. Default = \code{'mtml'}. Accepted arguments are:
\enumerate{
     \item \code{'stsl'} for the single-transmission single-linkage assumption (\code{\link{prob_trans_stsl}}).
     \item \code{'mtsl'} for the multiple-transmission single-linkage assumption (\code{\link{prob_trans_mtsl}}).
     \item \code{'mtml'} for the multiple-transmission multiple-linkage assumption (\code{\link{prob_trans_mtml}}).
     }}
}
\value{
scalar or vector giving the sample size needed to meet the given conditions
}
\description{
This function calculates the sample size needed to obtain at least a defined false disovery rate given 
a final outbreak size \eqn{N}.
}
\examples{
samplesize(eta=0.99, chi=0.995, N=100, R=1, phi=0.75)
}
\author{
John Giles, Shirlee Wohl, and Justin Lessler
}
\concept{inverse_functions}
