#' Dendrograms for evolutionary analysis.
#'
#' The phylogram package contains functions for importing and exporting
#' dendrogram objects in the Newick parenthetic text format, as well as
#' several functions for command-line tree manipulation.
#'
#' @section Functions:
#' A breif description of the primary \pkg{phylogram} functions are
#'   provided with links to their help pages below.
#'
#' @section File import/export:
#' \itemize{
#' \item \code{\link{read.dendrogram}} is a text parser that converts
#'   parenthetic text (Newick strings) into objects of class
#'   \code{"dendrogram"}
#' \item \code{\link{write.dendrogram}} outputs an object of class
#'   \code{"dendrogram"} to a text string or file in Newick/New Hampshire
#'   format
#' }
#'
#' @section Object conversion:
#' \itemize{
#' \item \code{\link{as.phylo.dendrogram}} converts a dendrogram to
#'   an object of class "phylo"
#'   \code{"dendrogram"}
#' \item \code{\link{as.dendrogram.phylo}} converts a "phylo" object
#'   to a dendrogram
#' }
#'
#' @section Tree editing and manipulation:
#' \itemize{
#' \item \code{\link{prune}} remove branches from a \code{dendrogram} object
#'   based on regular expression pattern matching
#' \item \code{\link{ladder}} reorders the branches of a \code{dendrogram}
#'   object to aid visualization
#' \item \code{\link{remidpoint}} recursively sets "midpoint" and "members"
#'   attributes for a nested list/\code{dendrogram} object
#' \item \code{\link{reposition}} shifts a \code{dendrogram} object up or
#'   down (or sideways if plotted horizontally)
#' \item \code{\link{ultrametricize}} modifies the "height" attributes of the
#'   nodes such that all leaves terminate at zero
#' }
#'
#' @docType package
#' @name phylogram
################################################################################
NULL
