% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Phyloinfer.R
\name{smcp_sampling}
\alias{smcp_sampling}
\title{SMC' sampler--inference from local genealogies}
\usage{
smcp_sampling(data, nsamp, nburnin, grid, alpha = 0.001, beta = 0.001,
  stepsz = 0.1, Nleap = 15, rand_leap = TRUE, scaling = 10,
  tol = 1e-05)
}
\arguments{
\item{data}{a list containing sufficient statistics}

\item{nsamp}{integer specifying number of MCMC samples}

\item{nburnin}{integer specifying the number of burnin samples}

\item{grid}{a vector with the grid points}

\item{alpha}{hyperparameter of precision of BM prior}

\item{beta}{hyperparameter of precision of BM prior}

\item{stepsz}{numeric tuning parameter for Split Hamiltonian Monte Carlo}

\item{Nleap}{integer tuning parameter for Split Hamiltonian Monte Carlo}

\item{rand_leap}{tuning parameter for Split Hamiltonian Monte Carlo}

\item{scaling}{numeric re-scaling parameter}

\item{tol}{tolerance to detect difference}
}
\value{
A matrix of sim rows. Entry x_{i,j} has the n-j+1-th coalescent time of the i-th tree
}
\description{
SMC' sampler--inference from local genealogies
}

