% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylocomr-package.R
\docType{package}
\name{phylocomr-package}
\alias{phylocomr-package}
\alias{phylocomr}
\title{Phylocom interface}
\description{
\code{phylocomr} gives you access to Phylocom, specifically the
Phylocom C library (https://github.com/phylocom/phylocom/),
licensed under BSD 2-clause
(http://www.opensource.org/licenses/bsd-license.php)
}
\details{
This package isn't doing system calls to a separately installed Phylocom
instance - but actually includes Phylocom itself in the package.

Phylocom is usually used either on the command line or through the
R package \pkg{picante}, which has duplicated some of the Phylocom
functionality.

In terms of performance, some functionality will be faster here than
in \code{picante}, but the maintainers of \code{picante} have re-written some
Phylocom functionality in C/C++, so performance should be similar in
those cases.
}
\section{A note about files}{

As a convienence you can pass ages, sample and trait data.frame's, and
phylogenies as strings, to \code{phylocomr} functions. However, \code{phylocomr}
has to write these data.frame's/strings to disk (your computer's
file system) to be able to run the Phylocom code on them. Internally,
\code{phylocomr} is writing to a temporary file to run Phylocom code, and
then the file is removed.

In addition, you can pass in files instead of data.frame's/strings.
These are not themselves used. Instead, we read and write those
files to temporary files. We do this for two reasons. First,
Phylocom expects the files its using to be in the same directory,
so if we control the file paths that becomes easier. Second,
Phylocom is case sensitive, so we simply standardize all taxon
names by lower casing all of them. We do this case manipulation
on the temporary files so that your original data files are
not modified.
}

\section{Package API}{

\itemize{
\item \code{\link[=ecovolve]{ecovolve()}}/\code{\link[=ph_ecovolve]{ph_ecovolve()}} - interface to \code{ecovolve} executable,
and a higher level interface
\item \code{\link[=phylomatic]{phylomatic()}}/\code{\link[=ph_phylomatic]{ph_phylomatic()}} - interface to \code{phylomatic}
executable, and a higher level interface
\item \code{\link[=phylocom]{phylocom()}} - interface to \code{phylocom} executable
\item \code{\link[=ph_aot]{ph_aot()}} - higher level interface to \code{aot}
\item \code{\link[=ph_bladj]{ph_bladj()}} - higher level interface to \code{bladj}
\item \code{\link[=ph_comdist]{ph_comdist()}}/\code{\link[=ph_comdistnt]{ph_comdistnt()}} - higher level interface to comdist
\item \code{\link[=ph_comstruct]{ph_comstruct()}} - higher level interface to comstruct
\item \code{\link[=ph_comtrait]{ph_comtrait()}} - higher level interface to comtrait
\item \code{\link[=ph_pd]{ph_pd()}} - higher level interface to Faith's phylogenetic diversity
}
}

\author{
Scott Chamberlain

Jeroen Ooms
}
