% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodeDepth.R
\name{nodeDepth}
\alias{nodeDepth}
\title{Node depth}
\usage{
nodeDepth(tree, node)
}
\arguments{
\item{tree}{a tree of class \code{phylo} or \code{phylo4}. The tree should be binary and rooted; if not it will be coerced into a binary rooted tree using multi2di, if possible.}

\item{node}{a number corresponding to a node in the tree.}
}
\value{
An integer corresponding to the depth of the given node.
}
\description{
Determine the depth of a particular node in a tree, defined as the number of edges between it and the root.
(So the root has depth zero, its children have depth one, etc.)
}
\examples{
## Find the depth of node 34 in a random tree with 20 tips:
tree <- rtree(20)
plot(tree)
nodelabels()
nodeDepth(tree,34)
 

}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}

