\name{homTrees}
\alias{homTrees}
\docType{data}
\title{
Homogeneous Trees
}
\description{
A list of 50 trees generated by a homogeneous model.
}
\usage{data(homTrees)}
\format{
A list of length 50 where each object is an object of class \code{phylo4}.
}
\details{
\code{ssTrees} and \code{homTrees} were created by models based on the spread of disease.  They they are from a transmission model with only one pathogen lineage per host. The former had a fifth of the hosts seeding five times as many infections as the others, and  while the latter was homogeneous - everyone was equally infectious. They all have 60 nodes or a little more.
}
\source{
\code{homTrees} was created by Caroline Colijn of Imperial College London.
}
\seealso{
\code{\link{exampleSummary}} for a more detailed summary.
}
\examples{
  data(homTrees)
  \dontrun{
  topList <- c(avgLadder,colless,function(tree){nConfig(tree,2)})
  treeListSummary(homTrees,topList)
}
}
\keyword{datasets}
