% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fitRMU.R
\name{fitRMU}
\alias{fitRMU}
\title{Adjusts incomplete timeseries with various constraints.}
\usage{
fitRMU(data = stop("data parameter must be provided"), method = "Constant",
  nbiter = 100, RMU.name = NULL, parameters = NULL,
  parametersfixed = NULL, optim = "BFGS", replicate.CI = 1000,
  colname.year = "Year", control = list(trace = 1, REPORT = 100, maxit =
  nbiter))
}
\arguments{
\item{data}{A data.frame with a column Year and two columns per rookery}

\item{method}{Can be Constant, Year-specific or Exponential}

\item{nbiter}{Maximum number of iterations before to show intermediate results}

\item{RMU.name}{A dataframe with two columns indicating name of columns for mean and standard error for roockerys}

\item{parameters}{Parameters to fit}

\item{parametersfixed}{Parameters that are fixed}

\item{optim}{Method of optim}

\item{replicate.CI}{Number of replicates to estimate CI}

\item{colname.year}{Name of the column to be used as time index}

\item{control}{List for control parameters of optim}
}
\value{
Return a list with two components: df_final and result
}
\description{
The data must be a data.frame with the first column being Year \cr
and two columns for each beach: the average and the se for the estimate.\cr
The correspondance between mean and se for each rookery are given in the RMU.name data.frame.\cr
}
\details{
fitRMU adjusts incomplete timeseries
}
\examples{
\dontrun{
RMU.name.AtlanticW <- data.frame(mean=c("Yalimapo.French.Guiana",
                                         "Galibi.Suriname",
                                         "Irakumpapy.French.Guiana"),
                                 se=c("se_Yalimapo.French.Guiana",
                                      "se_Galibi.Suriname",
                                      "se_Irakumpapy.French.Guiana"))
data.AtlanticW <- data.frame(Year=c(1990:2000),
      Yalimapo.French.Guiana=c(2076, 2765, 2890, 2678, NA,
                               6542, 5678, 1243, NA, 1566, 1566),
      se_Yalimapo.French.Guiana=c(123.2, 27.7, 62.5, 126, NA,
                                 230, 129, 167, NA, 145, 20),
      Galibi.Suriname=c(276, 275, 290, NA, 267,
                       542, 678, NA, 243, 156, 123),
      se_Galibi.Suriname=c(22.3, 34.2, 23.2, NA, 23.2,
                           4.3, 2.3, NA, 10.3, 10.1, 8.9),
      Irakumpapy.French.Guiana=c(1076, 1765, 1390, 1678, NA,
                               3542, 2678, 243, NA, 566, 566),
      se_Irakumpapy.French.Guiana=c(23.2, 29.7, 22.5, 226, NA,
                                 130, 29, 67, NA, 15, 20))

cst <- fitRMU(data=data.AtlanticW, RMU.name=RMU.name.AtlanticW,
               colname.year="Year", method="Constant")
expo <- fitRMU(data=data.AtlanticW, RMU.name=RMU.name.AtlanticW,
               colname.year="Year", method="Exponential")
YS <- fitRMU(data=data.AtlanticW, RMU.name=RMU.name.AtlanticW,
               colname.year="Year", method="Year-specific")

compare_AIC(Constant=cst$result, Exponential=expo$result,
YearSpecific=YS$result)

barplot_errbar(YS$mean, y.plus = YS$CI.0.95,
y.minus = YS$CI.0.05, las=1, ylim=c(0, 0.7),
main="Proportion of the different rookeries in the region")

plot_errbar(1990:2000, YS$result$par[paste0("T", 1990:2000)],
bty="n", las=1, ylab="Nest number", xlab="Nesting season",
errbar.y=2*YS$result$SE[paste0("T", 1990:2000)], ylim=c(0, 12000),
main="Total number of nests in all the rookeries in the region")
}
}
\author{
Marc Girondot
}

