% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_curvefits.R
\name{plot_curvefits}
\alias{plot_curvefits}
\title{plot_curvefits}
\usage{
plot_curvefits(
  d_fit,
  seasons,
  d_obs = NULL,
  title = NULL,
  xlab = "Time",
  ylab = "Vegetation Index",
  yticks = NULL,
  font.size = 14,
  theme = NULL,
  cex = 2,
  shape = "point",
  angle = 30,
  show.legend = TRUE,
  layer_extra = NULL,
  ...
)
}
\arguments{
\item{d_fit}{data.frame of curve fittings returned by \code{\link[=get_fitting]{get_fitting()}}.}

\item{seasons}{Growing season dividing object returned by \code{\link[=season]{season()}}
and \code{\link[=season_mov]{season_mov()}}.}

\item{d_obs}{data.frame of original vegetation time series, with the columns
of \code{t}, \code{y} and \code{QC_flag}. If not specified, it will be determined from \code{d_fit}.}

\item{title}{String, title of figure.}

\item{xlab, ylab}{String, title of \code{xlab} and \code{ylab}.}

\item{yticks}{ticks of y axis}

\item{font.size}{Font size of axis.text}

\item{theme}{ggplot theme}

\item{cex}{point size for VI observation.}

\item{shape}{the shape of input VI observation? \code{line} or \code{point}}

\item{angle}{\code{text.x} angle}

\item{show.legend}{Boolean}

\item{layer_extra}{(not used) extra ggplot layers}

\item{...}{ignored}
}
\description{
plot_curvefits
}
\examples{
data("CA_NS6")
d = CA_NS6

nptperyear <- 23
INPUT <- check_input(d$t, d$y, d$w, QC_flag = d$QC_flag,
     nptperyear = nptperyear, south = FALSE,
     maxgap = nptperyear/4, alpha = 0.02, wmin = 0.2)
# plot_input(INPUT)

# Rough fitting and growing season dividing
wFUN <- "wTSM"
brks2 <- season_mov(INPUT,
    options = list(
        rFUN = smooth_wWHIT, wFUN = wFUN,
        r_min = 0.05, ypeak_min = 0.05,
        lambda = 10,
        verbose = FALSE
    ))
# plot_season(INPUT, brks2, d)
# Fine fitting
fit <- curvefits(
    INPUT, brks2,
    options = list(
        methods = c("AG", "Beck", "Elmore", "Zhang"), #,"klos", "Gu"
        wFUN = wFUN,
        nextend = 2, maxExtendMonth = 2, minExtendMonth = 1, minPercValid = 0.2
    )
)

r_param = get_param(fit)
r_pheno = get_pheno(fit)
r_gof = get_GOF(fit)
d_fit = get_fitting(fit)

g <- plot_curvefits(d_fit, brks2)
grid::grid.newpage(); grid::grid.draw(g)
}
