% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncate_phenocam.r
\name{truncate_phenocam}
\alias{truncate_phenocam}
\title{Truncate a PhenoCam time series}
\usage{
truncate_phenocam(data, year = 2015, internal = TRUE,
  out_dir = tempdir())
}
\arguments{
\item{data}{a PhenoCam file or data frame}

\item{year}{the last valid year, discard the rest}

\item{internal}{return a data structure if given a file on disk
(\code{TRUE} / \code{FALSE} = default)}

\item{out_dir}{output directory where to store data (default = tempdir())}
}
\value{
A truncated PhenoCam data structure or file, with data limited to
the year specified.
}
\description{
The `expand_phenocam()` function provides a similar functionality and is
prefered. This function remains as it might serve a purpose to some. Might
be deprecated in the future.
}
\examples{

\donttest{
# download demo data
download_phenocam(site = "harvard$",
                  veg_type = "DB",
                  roi_id = "1000",
                  frequency = "3")
                  
# overwrites the original file, increasing
# decreasing the file size, with given year as maximum.
truncate_phenocam(file.paste(tempdir(),"harvard_DB_1000_3day.csv"),
                  year = 2015)
}
}
\keyword{phenocam}
\keyword{series,}
\keyword{smoothing,}
\keyword{time}
