% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nTTP_summary.R
\name{nTTP_summary}
\alias{nTTP_summary}
\title{Generate the mean nTTP score and the probability of observing DLT for all
doses and cycles}
\usage{
nTTP_summary(Tox.prob.M, nTTP.all, wm)
}
\arguments{
\item{Tox.prob.M}{Toxicity probability matrix with 4 dimension: dose,
cycle, type, grade. Tox.prob.M can be the output of the build-in matrix
of function \code{\link[phase1RMD]{GenToxProb}} in package phase1RMD.
See more details about how to generate toxicity probability matrices in
the help document of \code{\link[phase1RMD]{GenToxProb}}.}

\item{nTTP.all}{The output of \code{\link{nTTP.array}}}

\item{wm}{(numerical matrix) Toxicity weighted matrix, with row be the
type of the toxicity and column be the toxicity grade}
}
\value{
\item{mnTTP.M}{matrix of mean nTTP for all doses and cycles}
  \item{pDLT.M}{matrix of probability of observing DLT for all doses and
  cycles}
}
\description{
\code{nTTP_summary} generates the mean nTTP score and the probability of
observing DLT for all doses and cycles
}
\examples{

data("prob")

wm <- matrix(c(0, 0.5, 0.75, 1, 1.5,
               0, 0.5, 0.75, 1, 1.5,
               0, 0, 0, 0.5, 1),
             byrow = TRUE, ncol = 5)          # weighted matrix for toxicity matrix
                                              # nrow = No.of type; ncol = No. of grade
toxmax <- 2.5

nTTP.all <- nTTP.array(wm, toxmax)

tox.matrix <- prob["MTD4", "flat", , , , ]

nTTP_summary(tox.matrix, nTTP.all, wm)

}
