% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{set_tmdd}
\alias{set_tmdd}
\title{set_tmdd}
\usage{
set_tmdd(model, type, dv_types = NULL)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{type}{(str) Type of TMDD model}

\item{dv_types}{(list(str=numeric) (optional)) Dictionary of DV types for TMDD models with multiple DVs (e.g. dv_types = list('drug' = 1, 'target'= 2)).
Default is NULL which means that all observations are treated as drug observations.
For dv = 1 the only allowed keys are 'drug' and 'drug_tot'. If no DV for drug is specified then (free) drug
will have dv = 1.}
}
\value{
(Model) Pharmpy model object
}
\description{
Sets target mediated drug disposition

Implemented target mediated drug disposition (TMDD) models are:
\itemize{
\item Full model
\item Irreversible binding approximation (IB)
\item Constant total receptor approximation (CR)
\item Irreversible binding and constant total receptor approximation (CR+IB)
\item Quasi steady-state approximation (QSS)
\item Wagner
\item Michaelis-Menten approximation (MMAPP)
}
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model <- set_tmdd(model, "full")
}

}
