% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{evaluate_individual_prediction}
\alias{evaluate_individual_prediction}
\title{evaluate_individual_prediction}
\usage{
evaluate_individual_prediction(
  model,
  etas = NULL,
  parameters = NULL,
  dataset = NULL
)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{etas}{(data.frame (optional)) Optional list of eta values}

\item{parameters}{(list(str=numeric) (optional)) Optional list of parameters and values}

\item{dataset}{(data.frame (optional)) Optional dataset}
}
\value{
(data.frame) Individual predictions
}
\description{
Evaluate the numeric individual prediction

The prediction is evaluated at the current model parameter values
or optionally at the given parameter values.
The evaluation is done for each data record in the model dataset
or optionally using the dataset argument.
The evaluation is done at the current eta values
or optionally at the given eta values.

This function currently only support models without ODE systems
}
\examples{
\dontrun{
model <- load_example_model("pheno_linear")
results <- load_example_modelfit_results("pheno_linear")
etas <- results$individual_estimates
evaluate_individual_prediction(model, etas=etas)
}
}
\seealso{
evaluate_population_prediction : Evaluate the population prediction
}
