% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{create_joint_distribution}
\alias{create_joint_distribution}
\title{create_joint_distribution}
\usage{
create_joint_distribution(model, rvs = NULL)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{rvs}{(vector) Sequence of etas or names of etas to combine. If NULL, all etas that are IIVs and
non-fixed will be used (full block). NULL is default.}
}
\value{
(Model) Reference to the same model
}
\description{
Combines some or all etas into a joint distribution.

The etas must be IIVs and cannot
be fixed. Initial estimates for covariance between the etas is dependent on whether
the model has results from a previous results. In that case, the correlation will
be calculated from individual estimates, otherwise correlation will be set to 10\%.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model$random_variables$etas
create_joint_distribution(model, c('ETA(1)', 'ETA(2)'))
model$random_variables$etas
}
}
\seealso{
split_joint_distribution : split etas into separate distributions
}
