% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SH.R
\name{SH.test}
\alias{SH.test}
\title{Shimodaira-Hasegawa Test}
\usage{
SH.test(..., B = 10000, data = NULL, weight = NULL)
}
\arguments{
\item{...}{either a series of objects of class \code{"pml"} separated by
commas, a list containing such objects or an object of class \code{"pmlPart"}
or a matrix containing the site-wise likelihoods in columns.}

\item{B}{the number of bootstrap replicates.}

\item{data}{an object of class \code{"phyDat"}.}

\item{weight}{if a matrix with site (log-)likelihoods is is supplied an
optional vector containing the number of occurances of each site pattern.}
}
\value{
a numeric vector with the P-value associated with each tree given in
\code{...}.
}
\description{
This function computes the Shimodaira--Hasegawa test for a set of trees.
}
\examples{

data(Laurasiatherian)
dm <- dist.logDet(Laurasiatherian)
tree1 <- NJ(dm)
tree2 <- unroot(upgma(dm))
fit1 <- pml(tree1, Laurasiatherian)
fit2 <- pml(tree2, Laurasiatherian)
fit1 <- optim.pml(fit1) # optimize edge weights
fit2 <- optim.pml(fit2)
# with pml objects as input
SH.test(fit1, fit2, B=1000)
# in real analysis use larger B, e.g. 10000

# with matrix as input
X <- matrix(c(fit1$siteLik, fit2$siteLik), ncol=2)
SH.test(X, weight=attr(Laurasiatherian, "weight"), B=1000)
\dontrun{
example(pmlPart)
SH.test(sp, B=1000)
}
}
\references{
Shimodaira, H. and Hasegawa, M. (1999) Multiple comparisons of
log-likelihoods with applications to phylogenetic inference. \emph{Molecular
Biology and Evolution}, \bold{16}, 1114--1116.
}
\seealso{
\code{\link{pml}}, \code{\link{pmlPart}}, \code{\link{pmlCluster}},
\code{\link{SOWH.test}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{models}
