% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguExplorer.R
\name{pgu.explorer}
\alias{pgu.explorer}
\title{pgu.explorer}
\format{
\link[R6:R6Class]{R6::R6Class} object.
}
\description{
Visual exploration of the pguIMP dataset.
}
\details{
Pariwise anlysis of attributes from the pguIMP dataset.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\author{
Sebastian Malkusch, \email{malkusch@med.uni-frankfurt.de}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{rawData}}{Returns the instance variable rawData
(tibble::tibble)}

\item{\code{setRawData}}{Sets the instance variable rawData
(tibble::tibble)}

\item{\code{abscissa}}{Returns the instance variable abscissa
(character)}

\item{\code{setAbscissa}}{Sets the instance variable abscissa
(character)}

\item{\code{ordinate}}{Returns the instance variable ordinate
(character)}

\item{\code{setOrdinate}}{Sets the instance variable ordinate
(character)}

\item{\code{abscissaStatistics}}{Returns the instance variable abscissaStatistics
(character)}

\item{\code{ordinateStatistics}}{Returns the instance variable ordinateStatistics
(character)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{pgu.explorer$new()}}
\item \href{#method-print}{\code{pgu.explorer$print()}}
\item \href{#method-reset}{\code{pgu.explorer$reset()}}
\item \href{#method-fit}{\code{pgu.explorer$fit()}}
\item \href{#method-scatterPlot}{\code{pgu.explorer$scatterPlot()}}
\item \href{#method-abscissaBarPlot}{\code{pgu.explorer$abscissaBarPlot()}}
\item \href{#method-abscissaBoxPlot}{\code{pgu.explorer$abscissaBoxPlot()}}
\item \href{#method-abscissaPlot}{\code{pgu.explorer$abscissaPlot()}}
\item \href{#method-ordinateBarPlot}{\code{pgu.explorer$ordinateBarPlot()}}
\item \href{#method-ordinateBoxPlot}{\code{pgu.explorer$ordinateBoxPlot()}}
\item \href{#method-ordinatePlot}{\code{pgu.explorer$ordinatePlot()}}
\item \href{#method-clone}{\code{pgu.explorer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Tests if the abscissa attribute is of type numeric.


Tests if the ordinate attribute is of type numeric.


Summarizes the numeric values of a vector.


Calculates the statistics of the abscissa values.
Stores the result in the instance variable abscissaStatistics.


Calculates the statistics of the ordinate values.
Stores the result in the instance variable ordinateStatistics.


Clears the heap and
indicates that instance of \code{pgu.explorer} is removed from heap.


Creates and returns a new \code{pgu.explorer} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.explorer$new(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{pgu.explorer} object.
(pguIMP::pgu.optimizer)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a \code{pgu.explorer} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.explorer$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset"></a>}}
\if{latex}{\out{\hypertarget{method-reset}{}}}
\subsection{Method \code{reset()}}{
Resets the instance of the pgu.explorer class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.explorer$reset(data_df = "tbl_df", abs = "character", ord = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data to be analyzed.
(tibble::tibble)}

\item{\code{abs}}{The abscissa attribute
(character)}

\item{\code{ord}}{The ordinate attribute
(character)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
Calculates the abscissa and ordinate statistics
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.explorer$fit()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-scatterPlot"></a>}}
\if{latex}{\out{\hypertarget{method-scatterPlot}{}}}
\subsection{Method \code{scatterPlot()}}{
Creates and returns a scatter plot abscissa and ordinate value pairs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.explorer$scatterPlot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Scatter plot
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-abscissaBarPlot"></a>}}
\if{latex}{\out{\hypertarget{method-abscissaBarPlot}{}}}
\subsection{Method \code{abscissaBarPlot()}}{
Creates and returns a histogram from the abscissa values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.explorer$abscissaBarPlot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Bar plot
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-abscissaBoxPlot"></a>}}
\if{latex}{\out{\hypertarget{method-abscissaBoxPlot}{}}}
\subsection{Method \code{abscissaBoxPlot()}}{
Creates and returns a box plot from the abscissa values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.explorer$abscissaBoxPlot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Box plot
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-abscissaPlot"></a>}}
\if{latex}{\out{\hypertarget{method-abscissaPlot}{}}}
\subsection{Method \code{abscissaPlot()}}{
Creates and returns a compund graphical analysis of the abscissa values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.explorer$abscissaPlot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Compound plot
(gridExtra::grid.arrange)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ordinateBarPlot"></a>}}
\if{latex}{\out{\hypertarget{method-ordinateBarPlot}{}}}
\subsection{Method \code{ordinateBarPlot()}}{
Creates and returns a histogram from the ordinate values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.explorer$ordinateBarPlot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Bar plot
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ordinateBoxPlot"></a>}}
\if{latex}{\out{\hypertarget{method-ordinateBoxPlot}{}}}
\subsection{Method \code{ordinateBoxPlot()}}{
Creates and returns a box plot from the ordinate values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.explorer$ordinateBoxPlot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Box plot
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ordinatePlot"></a>}}
\if{latex}{\out{\hypertarget{method-ordinatePlot}{}}}
\subsection{Method \code{ordinatePlot()}}{
Creates and returns a compund graphical analysis of the ordinate values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.explorer$ordinatePlot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Compound plot
(gridExtra::grid.arrange)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.explorer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
