/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.ParseException;
import net.sf.eps2pgf.Options;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.io.LimitedSectionInputStream;
import net.sf.eps2pgf.io.TextReplacements;
import net.sf.eps2pgf.ps.DSCHeader;
import net.sf.eps2pgf.ps.Header;
import net.sf.eps2pgf.ps.Interpreter;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.objects.PSObjectFile;

public class Converter {
    private Options opts;

    public Converter(Options options) {
        this.opts = options;
    }

    public final void convert() throws IOException, PSError, ProgramError, ParseException {
        int[] nArray = Header.getPostScriptSection(this.opts.getInputFile());
        InputStream inputStream = new BufferedInputStream(new FileInputStream(this.opts.getInputFile()));
        if (nArray != null) {
            inputStream = new LimitedSectionInputStream(inputStream, nArray[0], nArray[1]);
        }
        DSCHeader dSCHeader = new DSCHeader(inputStream);
        TextReplacements textReplacements = null;
        if (this.opts.getTextreplacefile() != null) {
            textReplacements = new TextReplacements(this.opts.getTextreplacefile());
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.opts.getOutputFile()));
        Interpreter interpreter = new Interpreter(bufferedWriter, this.opts, dSCHeader, textReplacements);
        interpreter.getExecStack().push(new PSObjectFile(inputStream));
        try {
            interpreter.start();
        }
        catch (PSError pSError) {
            inputStream.close();
            ((Writer)bufferedWriter).close();
            throw pSError;
        }
        catch (ProgramError programError) {
            inputStream.close();
            ((Writer)bufferedWriter).close();
            throw programError;
        }
        catch (IOException iOException) {
            inputStream.close();
            ((Writer)bufferedWriter).close();
            throw iOException;
        }
        inputStream.close();
        ((Writer)bufferedWriter).close();
    }

    public void setOpts(Options options) {
        this.opts = options;
    }

    public Options getOpts() {
        return this.opts;
    }
}

