% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_distance.R
\name{euclidean_distance_kernel}
\alias{euclidean_distance_kernel}
\alias{kernel-distance}
\alias{manhattan_distance_kernel}
\alias{minkowski_distance_kernel}
\alias{chebyshev_distance_kernel}
\alias{vertical_distance_kernel}
\alias{horizontal_distance_kernel}
\alias{distance_kernel}
\title{Compute an Distance kernel}
\usage{
euclidean_distance_kernel(vertical_radius, horizontal_radius = vertical_radius)

manhattan_distance_kernel(vertical_radius, horizontal_radius = vertical_radius)

minkowski_distance_kernel(
  p,
  vertical_radius,
  horizontal_radius = vertical_radius
)

chebyshev_distance_kernel(vertical_radius, horizontal_radius = vertical_radius)

vertical_distance_kernel(vertical_radius, horizontal_radius = vertical_radius)

horizontal_distance_kernel(
  vertical_radius,
  horizontal_radius = vertical_radius
)

distance_kernel(vertical_radius, horizontal_radius = vertical_radius)
}
\arguments{
\item{vertical_radius}{\strong{[numeric]} The kernel's radius in the vertical
dimension.}

\item{horizontal_radius}{\strong{[numeric]} The kernel's radius in the horizontal
dimension.}

\item{p}{\strong{[numeric]} Exponent parameter for the Minkowski distance.}
}
\value{
A \code{matrix} corresponding to the kernel.
}
\description{
Functions to compute a distance kernel.
}
\examples{

distance_kernel(vertical_radius = 2, horizontal_radius = 2)
euclidean_distance_kernel(vertical_radius = 2, horizontal_radius = 2)
manhattan_distance_kernel(vertical_radius = 2, horizontal_radius = 2)
minkowski_distance_kernel(vertical_radius = 2, horizontal_radius = 2, p = 1)
chebyshev_distance_kernel(vertical_radius = 2, horizontal_radius = 2)
vertical_distance_kernel(vertical_radius = 2, horizontal_radius = 2)
horizontal_distance_kernel(vertical_radius = 2, horizontal_radius = 2)

}
